/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.datetime;

import com.orgzly.org.OrgPatterns;
import com.orgzly.org.OrgStringUtils;
import com.orgzly.org.datetime.OrgDateTime;
import java.util.Calendar;
import java.util.regex.Matcher;

public class OrgRange {
    private OrgDateTime startTime;
    private OrgDateTime endTime;

    public static OrgRange parseOrNull(String str) {
        if (OrgStringUtils.isEmpty(str)) {
            return null;
        }
        return OrgRange.parse(str);
    }

    public static OrgRange parse(String str) {
        if (str == null) {
            throw new IllegalArgumentException("OrgRange cannot be created from null string");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException("OrgRange cannot be created from null string");
        }
        OrgRange t = new OrgRange();
        Matcher m = OrgPatterns.DT_OR_RANGE_P.matcher(str);
        if (m.find()) {
            if (m.groupCount() == 6 && m.group(6) != null) {
                t.startTime = OrgDateTime.parse(m.group(2));
                t.endTime = OrgDateTime.parse(m.group(5));
            } else {
                t.startTime = OrgDateTime.parse(m.group(2));
                t.endTime = null;
            }
            return t;
        }
        throw new IllegalArgumentException("String " + str + " cannot be parsed as OrgRange using pattern " + OrgPatterns.DT_OR_RANGE_P);
    }

    public static OrgRange doParse(String str) {
        try {
            OrgRange range = OrgRange.parse(str);
            range.startTime.getCalendar();
            if (range.endTime != null) {
                range.endTime.getCalendar();
            }
            return range;
        }
        catch (Exception e) {
            return null;
        }
    }

    private OrgRange() {
    }

    public OrgRange(OrgDateTime fromTime) {
        this(fromTime, null);
    }

    public OrgRange(OrgDateTime fromTime, OrgDateTime endTime) {
        if (fromTime == null) {
            throw new IllegalArgumentException("OrgRange cannot be created from null OrgDateTime");
        }
        this.startTime = fromTime;
        this.endTime = endTime;
    }

    public OrgDateTime getStartTime() {
        return this.startTime;
    }

    public OrgDateTime getEndTime() {
        return this.endTime;
    }

    public boolean isSet() {
        return this.startTime != null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.startTime);
        if (this.endTime != null) {
            s.append("--");
            s.append(this.endTime);
        }
        return s.toString();
    }

    public String toStringWithoutBrackets() {
        StringBuilder s = new StringBuilder();
        s.append(this.startTime.toStringWithoutBrackets());
        if (this.endTime != null) {
            s.append("--");
            s.append(this.endTime.toStringWithoutBrackets());
        }
        return s.toString();
    }

    public boolean shift() {
        return this.shift(Calendar.getInstance());
    }

    public boolean shift(Calendar now) {
        boolean shifted = false;
        if (this.startTime != null && this.startTime.shift(now)) {
            shifted = true;
        }
        if (this.endTime != null && this.endTime.shift(now)) {
            shifted = true;
        }
        return shifted;
    }
}

