/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.parser;

import java.util.HashSet;
import java.util.Set;

public class OrgParserSettings {
    public SeparateNotesWithNewLine separateNotesWithNewLine;
    public boolean separateHeaderAndContentWithNewLine = true;
    String propertyFormat = "%-10s %s";
    Set<String> todoKeywords = new HashSet<String>();
    Set<String> doneKeywords = new HashSet<String>();
    public int tagsColumn = 0;
    public boolean orgIndentMode = false;
    public int orgIndentIndentationPerLevel = 2;

    OrgParserSettings() {
        this.separateNotesWithNewLine = SeparateNotesWithNewLine.MULTI_LINE_NOTES_ONLY;
    }

    OrgParserSettings(OrgParserSettings that) {
        this();
        this.propertyFormat = that.propertyFormat;
        this.todoKeywords.addAll(that.todoKeywords);
        this.doneKeywords.addAll(that.doneKeywords);
        this.separateNotesWithNewLine = that.separateNotesWithNewLine;
        this.tagsColumn = that.tagsColumn;
        this.orgIndentMode = that.orgIndentMode;
        this.orgIndentIndentationPerLevel = that.orgIndentIndentationPerLevel;
    }

    public static OrgParserSettings getBasic() {
        OrgParserSettings settings = new OrgParserSettings();
        settings.todoKeywords.add("TODO");
        settings.doneKeywords.add("DONE");
        return settings;
    }

    public static enum SeparateNotesWithNewLine {
        ALWAYS,
        MULTI_LINE_NOTES_ONLY,
        NEVER;

    }
}

