/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.parser;

import com.orgzly.org.OrgHead;
import com.orgzly.org.OrgProperties;
import com.orgzly.org.OrgStringUtils;
import com.orgzly.org.parser.OrgNode;
import com.orgzly.org.parser.OrgParserSettings;

public class OrgParserWriter {
    private static final String[] ORG_LOG_NOTE_HEADINGS = new String[]{"CLOSING NOTE ", "State ", "Note taken on ", "Rescheduled from ", "Not scheduled, was ", "New deadline from ", "Removed deadline, was ", "Refiled on "};
    private OrgParserSettings settings;

    public OrgParserWriter() {
        this.settings = OrgParserSettings.getBasic();
    }

    public OrgParserWriter(OrgParserSettings settings) {
        this.settings = settings;
    }

    public String whiteSpacedFilePreface(String content) {
        if (content == null || content.length() == 0) {
            return "";
        }
        return OrgStringUtils.trimLines(content) + "\n\n";
    }

    public String whiteSpacedHead(OrgNode node, boolean isIndented) {
        return this.whiteSpacedHead(node.getHead(), node.getLevel(), isIndented);
    }

    public String whiteSpacedHead(OrgHead head, int level, boolean isIndented) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            s.append("*");
        }
        s.append(" ");
        if (head.getState() != null) {
            s.append(head.getState()).append(" ");
        }
        if (head.getPriority() != null) {
            s.append("[#").append(head.getPriority()).append("] ");
        }
        s.append(head.getTitle());
        if (head.hasTags()) {
            StringBuilder ts = new StringBuilder();
            s.append(" ");
            for (int i = 0; i < head.getTags().size(); ++i) {
                ts.append(":").append(head.getTags().get(i));
            }
            ts.append(":");
            int padding = Math.abs(this.settings.tagsColumn) - s.length();
            if (this.settings.orgIndentMode && this.settings.orgIndentIndentationPerLevel > 0) {
                padding -= (this.settings.orgIndentIndentationPerLevel - 1) * (level - 1);
            }
            if (this.settings.tagsColumn < 0) {
                padding -= ts.length();
            }
            while (padding > 0) {
                s.append(" ");
                --padding;
            }
            s.append(ts.toString());
        }
        boolean hasUnderHead = false;
        if (head.hasClosed()) {
            s.append("\n");
            this.appendIndent(s, level, isIndented);
            s.append("CLOSED: ").append(head.getClosed());
            hasUnderHead = true;
        }
        if (head.hasDeadline()) {
            if (hasUnderHead) {
                s.append(" ");
            } else {
                s.append("\n");
                this.appendIndent(s, level, isIndented);
            }
            s.append("DEADLINE: ").append(head.getDeadline());
            hasUnderHead = true;
        }
        if (head.hasScheduled()) {
            if (hasUnderHead) {
                s.append(" ");
            } else {
                s.append("\n");
                this.appendIndent(s, level, isIndented);
            }
            s.append("SCHEDULED: ").append(head.getScheduled());
            hasUnderHead = true;
        }
        if (head.hasClock()) {
            s.append("\n");
            this.appendIndent(s, level, isIndented);
            s.append("CLOCK: ").append(head.getClock());
            hasUnderHead = true;
        }
        if (head.hasProperties()) {
            s.append("\n");
            this.appendIndent(s, level, isIndented);
            s.append(":PROPERTIES:");
            OrgProperties properties = head.getProperties();
            for (String name : properties.keySet()) {
                String value = (String)properties.get(name);
                s.append("\n");
                this.appendIndent(s, level, isIndented);
                s.append(String.format(this.settings.propertyFormat, ":" + name + ":", value));
            }
            s.append("\n");
            this.appendIndent(s, level, isIndented);
            s.append(":END:");
            hasUnderHead = true;
        }
        if (head.hasLogbook()) {
            s.append("\n");
            this.appendIndent(s, level, isIndented);
            s.append(":LOGBOOK:");
            for (String log : head.getLogbook()) {
                s.append("\n");
                this.appendIndent(s, level, isIndented);
                s.append(log);
            }
            s.append("\n");
            this.appendIndent(s, level, isIndented);
            s.append(":END:");
            hasUnderHead = true;
        }
        s.append("\n");
        if (head.hasContent()) {
            String content = head.getContent().trim();
            if (!content.startsWith(":LOGBOOK:") && !content.startsWith("CLOCK: ") && !this.isLogNoteHeading(content) && this.settings.separateHeaderAndContentWithNewLine) {
                s.append("\n");
            }
            s.append(head.getContent());
            s.append("\n");
            if (this.settings.separateNotesWithNewLine == OrgParserSettings.SeparateNotesWithNewLine.MULTI_LINE_NOTES_ONLY) {
                s.append("\n");
            }
        } else if (hasUnderHead && this.settings.separateNotesWithNewLine == OrgParserSettings.SeparateNotesWithNewLine.MULTI_LINE_NOTES_ONLY) {
            s.append("\n");
        }
        if (this.settings.separateNotesWithNewLine == OrgParserSettings.SeparateNotesWithNewLine.ALWAYS) {
            s.append("\n");
        }
        return s.toString();
    }

    private boolean isLogNoteHeading(String content) {
        for (String s : ORG_LOG_NOTE_HEADINGS) {
            if (!content.startsWith("- " + s)) continue;
            return true;
        }
        return false;
    }

    private void appendIndent(StringBuilder s, int level, boolean isIndented) {
        if (isIndented) {
            for (int i = 0; i < level + 1; ++i) {
                s.append(" ");
            }
        }
    }
}

