/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.parser;

import com.orgzly.org.OrgFile;
import com.orgzly.org.OrgHead;
import com.orgzly.org.OrgPatterns;
import com.orgzly.org.OrgStringUtils;
import com.orgzly.org.datetime.OrgRange;
import com.orgzly.org.parser.OrgNode;
import com.orgzly.org.parser.OrgNodeInList;
import com.orgzly.org.parser.OrgParsedFile;
import com.orgzly.org.parser.OrgParser;
import com.orgzly.org.parser.OrgParserSettings;
import com.orgzly.org.parser.OrgSaxyParserListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OrgSaxyParser
extends OrgParser {
    private static final int FIRST_HEADING_POSITION_NUMBER = 1;
    private BufferedReader reader;
    private OrgSaxyParserListener listener;
    private Pattern statePattern;

    public OrgSaxyParser(OrgParserSettings settings, Reader reader, OrgSaxyParserListener listener) {
        this.settings = settings;
        this.reader = new BufferedReader(reader);
        this.listener = listener;
        this.statePattern = this.buildStatePattern(settings.todoKeywords, settings.doneKeywords);
    }

    private Pattern buildStatePattern(Set<String> todoKeywords, Set<String> doneKeywords) {
        HashSet<String> allKeywords = new HashSet<String>();
        if (todoKeywords != null) {
            for (String keyword : todoKeywords) {
                allKeywords.add(Pattern.quote(keyword));
            }
        }
        if (doneKeywords != null) {
            for (String keyword : doneKeywords) {
                allKeywords.add(Pattern.quote(keyword));
            }
        }
        if (allKeywords.size() > 0) {
            return Pattern.compile("^(" + OrgStringUtils.join(allKeywords, "|") + ")(.*)");
        }
        return null;
    }

    @Override
    public OrgParsedFile parse() throws IOException {
        String line;
        OrgFile orgFile = new OrgFile();
        StringBuilder preface = new StringBuilder();
        OrgNode currentElement = null;
        boolean isAfterHeading = false;
        boolean inProperties = false;
        int nextFreePosition = 1;
        int indentedCount = 0;
        while ((line = this.reader.readLine()) != null) {
            if (currentElement == null && orgFile.getSettings().parseLine(line)) {
                preface.append(line);
                preface.append('\n');
                continue;
            }
            OrgNodeInList head = this.tryParsingHeading(line, nextFreePosition);
            if (head != null) {
                if (currentElement != null) {
                    this.trimContent(currentElement.getHead());
                    this.listener.onHead((OrgNodeInList)currentElement);
                }
                currentElement = head;
                isAfterHeading = true;
                inProperties = false;
                ++nextFreePosition;
                continue;
            }
            if (currentElement != null) {
                if (isAfterHeading) {
                    boolean found = false;
                    Matcher m = OrgPatterns.PLANNING_TIMES_P.matcher(line);
                    while (m.find()) {
                        String timeKey = m.group(1);
                        String timeString = m.group(2);
                        switch (timeKey) {
                            case "SCHEDULED:": {
                                currentElement.getHead().setScheduled(OrgRange.parse(timeString));
                                break;
                            }
                            case "CLOSED:": {
                                currentElement.getHead().setClosed(OrgRange.parse(timeString));
                                break;
                            }
                            case "DEADLINE:": {
                                currentElement.getHead().setDeadline(OrgRange.parse(timeString));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown time key " + timeKey);
                            }
                        }
                        found = true;
                    }
                    String lineTrimmed = line.trim();
                    if (!inProperties && ":PROPERTIES:".equals(lineTrimmed)) {
                        inProperties = true;
                        found = true;
                    } else if (inProperties && ":END:".equals(lineTrimmed)) {
                        inProperties = false;
                        found = true;
                    } else if (inProperties) {
                        Matcher propertyMatcher = OrgPatterns.PROPERTY.matcher(lineTrimmed);
                        if (propertyMatcher.find()) {
                            ((OrgNodeInList)currentElement).head.addProperty(propertyMatcher.group(1), propertyMatcher.group(2));
                        }
                        found = true;
                    }
                    int spacesBeforeContent = line.indexOf(lineTrimmed);
                    if (found) {
                        indentedCount = spacesBeforeContent > 0 ? ++indentedCount : --indentedCount;
                    }
                    if (found) continue;
                }
                currentElement.getHead().appendContent(line);
                currentElement.getHead().appendContent("\n");
            } else {
                preface.append(line);
                preface.append('\n');
            }
            isAfterHeading = false;
        }
        if (currentElement != null) {
            this.trimContent(currentElement.getHead());
            this.listener.onHead((OrgNodeInList)currentElement);
        }
        this.setTrimmedPreface(orgFile, preface.toString());
        orgFile.getSettings().setIndented(indentedCount > 0);
        this.listener.onFile(orgFile);
        return null;
    }

    private OrgNodeInList tryParsingHeading(String line, int position) {
        OrgNodeInList entry = null;
        Matcher headMatcher = OrgPatterns.HEAD_P.matcher(line);
        if (headMatcher.find()) {
            int level = headMatcher.group(1).length();
            String head = headMatcher.group(2);
            entry = this.parseHeading(position, level, head);
        }
        return entry;
    }

    private OrgNodeInList parseHeading(int position, int level, String str) {
        Matcher m;
        Matcher stateMatcher;
        OrgHead head = new OrgHead();
        OrgNodeInList element = new OrgNodeInList(position, level, head);
        String title = str.trim();
        if (this.statePattern != null && (stateMatcher = this.statePattern.matcher(title)).find() && (stateMatcher.group(2).length() == 0 || stateMatcher.group(2).startsWith(" "))) {
            head.setState(stateMatcher.group(1));
            title = stateMatcher.group(2).trim();
        }
        if ((m = OrgPatterns.HEAD_PRIORITY_P.matcher(title)).find()) {
            head.setPriority(m.group(1));
            title = m.group(2).trim();
        }
        if ((m = OrgPatterns.HEAD_TAGS_P.matcher(title)).find()) {
            title = m.group(1).trim();
            head.setTags(m.group(2).split(":"));
        }
        head.setTitle(title);
        return element;
    }

    private void trimContent(OrgHead head) {
        head.setContent(OrgStringUtils.trimLines(head.getContent()));
    }

    private void setTrimmedPreface(OrgFile file, String preface) {
        file.setPreface(OrgStringUtils.trimLines(preface));
    }
}

