/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.utils;

import com.orgzly.org.datetime.OrgDateTime;
import com.orgzly.org.datetime.OrgRange;
import java.util.Set;

public class StateChangeLogic {
    private final Set<String> doneKeywords;
    private String state;
    private OrgRange scheduled;
    private OrgRange deadline;
    private OrgRange closed;

    public StateChangeLogic(Set<String> doneKeywords) {
        this.doneKeywords = doneKeywords;
    }

    public void setState(String targetState, String originalState, OrgRange scheduledTime, OrgRange deadlineTime) {
        if (targetState == null) {
            throw new IllegalArgumentException("Target state cannot be null");
        }
        this.scheduled = scheduledTime;
        this.deadline = deadlineTime;
        if (this.doneKeywords.contains(targetState)) {
            if (!this.doneKeywords.contains(originalState)) {
                boolean shifted = false;
                if (this.scheduled != null && this.scheduled.shift()) {
                    shifted = true;
                }
                if (this.deadline != null && this.deadline.shift()) {
                    shifted = true;
                }
                if (shifted) {
                    this.state = originalState;
                    this.closed = null;
                } else {
                    this.state = targetState;
                    this.closed = new OrgRange(new OrgDateTime(false));
                }
            } else {
                this.state = targetState;
                this.closed = new OrgRange(new OrgDateTime(false));
            }
        } else {
            this.state = targetState;
            this.closed = null;
        }
    }

    public String getState() {
        return this.state;
    }

    public OrgRange getScheduled() {
        return this.scheduled;
    }

    public OrgRange getDeadline() {
        return this.deadline;
    }

    public OrgRange getClosed() {
        return this.closed;
    }
}

