/*
 * Decompiled with CFR 0.152.
 */
package com.ost.lib;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.ByteString;

public class OSTRequestClient {
    private String apiKey;
    private String apiSecret;
    private String apiEndpoint;
    private Long timeout;
    private static final Gson gson = new Gson();
    private OkHttpClient client;
    private static final Escaper FormParameterEscaper = UrlEscapers.urlFormParameterEscaper();
    private static final Escaper PathSegmentEscaper = UrlEscapers.urlPathSegmentEscaper();
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static Boolean DEBUG = "true".equalsIgnoreCase(System.getenv("OST_SDK_DEBUG"));
    private static Boolean VERBOSE = false;
    private static String GET_REQUEST = "GET";
    private static String POST_REQUEST = "POST";
    private static String DELETE_REQUEST = "DELETE";
    private static String SocketTimeoutExceptionString = "{'success':'false','err':{'code':'GATEWAY_TIMEOUT','internal_id':'SDK(GATEWAY_TIMEOUT)','msg':'','error_data':[]}}";
    private static String SOMETHING_WRONG_RESPONSE = "{'success': false, 'err': {'code': 'SOMETHING_WENT_WRONG', 'internal_id': 'SDK(SOMETHING_WENT_WRONG)', 'msg': '', 'error_data':[]}}";

    public OSTRequestClient(Map<String, Object> params) {
        HashMap config;
        Object apiKey = params.get("apiKey");
        Object apiSecret = params.get("apiSecret");
        Object apiEndpoint = params.get("apiEndpoint");
        long timeout = 60L;
        if (params.containsKey("config") && (config = (HashMap)params.get("config")).containsKey("timeout")) {
            timeout = (Long)config.get("timeout");
        }
        if (!(apiKey instanceof String)) {
            throw new IllegalArgumentException("Api key not present.");
        }
        if (!(apiSecret instanceof String)) {
            throw new IllegalArgumentException("Api secret not present.");
        }
        if (!(apiEndpoint instanceof String)) {
            throw new IllegalArgumentException("Api EndPoint not present.");
        }
        this.apiKey = (String)apiKey;
        this.apiSecret = (String)apiSecret;
        this.apiEndpoint = (String)apiEndpoint;
        this.timeout = timeout;
        if (this.apiEndpoint.endsWith("/")) {
            this.apiEndpoint = this.apiEndpoint.substring(0, this.apiEndpoint.length() - 1);
        }
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(500);
        dispatcher.setMaxRequestsPerHost(150);
        this.client = new OkHttpClient.Builder().connectionPool(new ConnectionPool(10, 2L, TimeUnit.MINUTES)).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(timeout, TimeUnit.SECONDS).dispatcher(dispatcher).retryOnConnectionFailure(false).build();
    }

    public JsonObject get(String resource, Map<String, Object> queryParams) throws IOException {
        return this.send(GET_REQUEST, resource, queryParams);
    }

    public JsonObject post(String resource, Map<String, Object> queryParams) throws IOException {
        return this.send(POST_REQUEST, resource, queryParams);
    }

    public JsonObject delete(String resource, Map<String, Object> queryParams) throws IOException {
        return this.send(DELETE_REQUEST, resource, queryParams);
    }

    private JsonObject send(String requestType, String resource, Map<String, Object> mapParams) throws IOException {
        String responseBody;
        if (!(requestType.equalsIgnoreCase(POST_REQUEST) || requestType.equalsIgnoreCase(GET_REQUEST) || requestType.equalsIgnoreCase(DELETE_REQUEST))) {
            throw new IOException("Invalid requestType");
        }
        if (null == mapParams) {
            mapParams = new ConcurrentSkipListMap<String, Object>();
        }
        Request.Builder requestBuilder = new Request.Builder();
        HttpUrl baseUrl = HttpUrl.parse((String)(this.apiEndpoint + resource));
        HttpUrl.Builder urlBuilder = baseUrl.newBuilder(resource);
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (null == urlBuilder) {
            throw new IOException("Failed to instantiate HttpUrl.Builder. resource or Api Endpoint is incorrect.");
        }
        HttpUrl url = urlBuilder.build();
        urlBuilder = baseUrl.newBuilder();
        ArrayList<Object> params = new ArrayList();
        mapParams.put("api_key", this.apiKey);
        mapParams.put("api_signature_kind", "OST1-HMAC-SHA256");
        mapParams.put("api_request_timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params = this.getRequestParam(resource, mapParams);
        for (HttpParam httpParam : params) {
            String paramKey = httpParam.getParamName();
            String paramVal = httpParam.getParamValue();
            if (GET_REQUEST.equalsIgnoreCase(requestType) || DELETE_REQUEST.equalsIgnoreCase(requestType)) {
                urlBuilder.addEncodedQueryParameter(paramKey, paramVal);
                continue;
            }
            formBodyBuilder.addEncoded(paramKey, paramVal);
        }
        url = urlBuilder.build();
        if (DEBUG.booleanValue()) {
            System.out.println("url = " + url.toString());
        }
        requestBuilder.url(url);
        if (GET_REQUEST.equalsIgnoreCase(requestType)) {
            requestBuilder.get().addHeader("content-type", "x-www-form-urlencoded");
        } else if (DELETE_REQUEST.equalsIgnoreCase(requestType)) {
            requestBuilder.delete().addHeader("content-type", "x-www-form-urlencoded");
        } else {
            FormBody formBody = formBodyBuilder.build();
            if (DEBUG.booleanValue() && VERBOSE.booleanValue()) {
                for (int i = 0; i < formBody.size(); ++i) {
                    System.out.println(formBody.name(i) + "\t\t" + formBody.value(i));
                }
            }
            requestBuilder.post((RequestBody)formBody);
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        try {
            Response response = call.execute();
            responseBody = OSTRequestClient.getResponseBodyAsString(response);
        }
        catch (SocketTimeoutException e) {
            responseBody = SocketTimeoutExceptionString;
        }
        return OSTRequestClient.buildApiResponse(responseBody);
    }

    public ArrayList<HttpParam> getRequestParam(String resource, Map<String, Object> paramValObj) {
        String paramVal;
        Buffer hmacInputBuffer = new Buffer();
        hmacInputBuffer.writeUtf8(resource);
        hmacInputBuffer.writeByte(63);
        ArrayList<HttpParam> params = new ArrayList<HttpParam>();
        ArrayList<HttpParam> escapedParams = new ArrayList<HttpParam>();
        params = OSTRequestClient.buildNestedQuery(params, "", paramValObj);
        Iterator<HttpParam> it = params.iterator();
        boolean firstParam = true;
        while (it.hasNext()) {
            HttpParam pair = it.next();
            String paramKey = pair.getParamName();
            paramVal = pair.getParamValue();
            paramKey = OSTRequestClient.specialCharacterEscape(paramKey);
            paramVal = OSTRequestClient.specialCharacterEscape(paramVal);
            if (!firstParam) {
                hmacInputBuffer.writeByte(38);
            }
            firstParam = false;
            hmacInputBuffer.writeUtf8(paramKey);
            hmacInputBuffer.writeByte(61);
            hmacInputBuffer.writeUtf8(paramVal);
            escapedParams.add(new HttpParam(paramKey, paramVal));
            if (!DEBUG.booleanValue()) continue;
            System.out.println("paramKey " + paramKey + " paramVal " + paramVal);
        }
        paramVal = this.signQueryParams(hmacInputBuffer);
        escapedParams.add(new HttpParam("api_signature", paramVal));
        return escapedParams;
    }

    private String signQueryParams(Buffer hmacInputBuffer) {
        Mac mac;
        SecretKeySpec keySpec = new SecretKeySpec(this.apiSecret.getBytes(UTF_8), HMAC_SHA256);
        try {
            mac = Mac.getInstance(HMAC_SHA256);
            mac.init(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        byte[] bytes = hmacInputBuffer.readByteArray();
        if (DEBUG.booleanValue()) {
            System.out.println("bytes to sign: " + new String(bytes, UTF_8));
        }
        byte[] result = mac.doFinal(bytes);
        String api_signature = ByteString.of((byte[])result).hex();
        if (DEBUG.booleanValue()) {
            System.out.println("api_signature: " + api_signature);
        }
        return api_signature;
    }

    private static String getResponseBodyAsString(Response response) {
        String responseBody;
        if (response.body() != null) {
            try {
                responseBody = response.body().string();
                if (responseBody.length() > 0) {
                    if (DEBUG.booleanValue()) {
                        System.out.println("responseCode: " + response.code() + "\nresponseBody:\n" + responseBody + "\n");
                    }
                    return responseBody;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        switch (response.code()) {
            case 400: {
                responseBody = "{'success': false, 'err': {'code': 'BAD_REQUEST', 'internal_id': 'SDK(BAD_REQUEST)', 'msg': '', 'error_data':[]}}";
                break;
            }
            case 429: {
                responseBody = "{'success': false, 'err': {'code': 'TOO_MANY_REQUESTS', 'internal_id': 'SDK(TOO_MANY_REQUESTS)', 'msg': '', 'error_data':[]}}";
                break;
            }
            case 502: {
                responseBody = "{'success': false, 'err': {'code': 'BAD_GATEWAY', 'internal_id': 'SDK(BAD_GATEWAY)', 'msg': '', 'error_data':[]}}";
                break;
            }
            case 503: {
                responseBody = "{'success': false, 'err': {'code': 'SERVICE_UNAVAILABLE', 'internal_id': 'SDK(SERVICE_UNAVAILABLE)', 'msg': '', 'error_data':[]}}";
                break;
            }
            case 504: {
                responseBody = "{'success': false, 'err': {'code': 'GATEWAY_TIMEOUT', 'internal_id': 'SDK(GATEWAY_TIMEOUT)', 'msg': '', 'error_data':[]}}";
                break;
            }
            default: {
                responseBody = SOMETHING_WRONG_RESPONSE;
            }
        }
        if (DEBUG.booleanValue()) {
            System.out.println("local responseBody:\n" + responseBody + "\n");
        }
        return responseBody;
    }

    private static JsonObject buildApiResponse(String jsonString) {
        try {
            return (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (DEBUG.booleanValue()) {
                System.out.println("Failed to parse response. local responseBody:\n" + SOMETHING_WRONG_RESPONSE + "\n");
            }
            return (JsonObject)gson.fromJson(SOMETHING_WRONG_RESPONSE, JsonObject.class);
        }
    }

    private static ArrayList<HttpParam> buildNestedQuery(ArrayList<HttpParam> params, String paramKeyPrefix, Object paramValObj) {
        if (paramValObj instanceof Map) {
            TreeMap sortedMap = new TreeMap((Map)paramValObj);
            Iterator iterator = sortedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry paramPair;
                Map.Entry pair = paramPair = iterator.next();
                String key = (String)pair.getKey();
                Object value = pair.getValue();
                String prefix = "";
                prefix = paramKeyPrefix.isEmpty() ? key : paramKeyPrefix + "[" + key + "]";
                params = OSTRequestClient.buildNestedQuery(params, prefix, value);
            }
        } else if (paramValObj instanceof Collection) {
            for (Object value : (Collection)paramValObj) {
                String prefix = paramKeyPrefix + "[]";
                params = OSTRequestClient.buildNestedQuery(params, prefix, value);
            }
        } else if (paramValObj != null) {
            params.add(new HttpParam(paramKeyPrefix, paramValObj.toString()));
        } else {
            params.add(new HttpParam(paramKeyPrefix, ""));
        }
        return params;
    }

    private static String specialCharacterEscape(String stringToEscape) {
        stringToEscape = FormParameterEscaper.escape(stringToEscape);
        stringToEscape = stringToEscape.replace("*", "%2A");
        stringToEscape = stringToEscape.replace("%7E", "~");
        return stringToEscape;
    }

    public static class HttpParam {
        private String paramName;
        private String paramValue;

        public HttpParam() {
        }

        public HttpParam(String paramName, String paramValue) {
            this.paramName = paramName;
            this.paramValue = paramValue;
        }

        public String getParamValue() {
            return this.paramValue;
        }

        public void setParamValue(String paramValue) {
            this.paramValue = paramValue;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }
    }
}

