/*
 * Decompiled with CFR 0.152.
 */
package com.ost.services;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.ost.lib.OSTRequestClient;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class OSTAPIService {
    protected OSTRequestClient request;
    protected String urlPrefix;
    protected String urlSuffix;
    private static final Escaper FormParameterEscaper = UrlEscapers.urlFormParameterEscaper();

    public OSTAPIService(OSTRequestClient ostRequestClient) {
        this.request = ostRequestClient;
        this.urlPrefix = "";
        this.urlSuffix = "";
    }

    public OSTAPIService(OSTRequestClient ostRequestClient, String servicePrefix, String serviceSuffix) {
        this(ostRequestClient);
        this.urlPrefix = servicePrefix;
        this.urlSuffix = serviceSuffix;
    }

    public String getSessionAddress(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String sessionAddress = "";
        if (null == params || !params.containsKey("session_address") || null == params.get("session_address")) {
            throw new MissingParameter("session_address");
        }
        if (!this.isValidParameter(params.get("session_address")).booleanValue()) {
            throw new InvalidParameter("session_address");
        }
        sessionAddress = params.get("session_address").toString();
        params.remove("session_address");
        return OSTAPIService.specialCharacterEscape(sessionAddress);
    }

    public String getDeviceAddress(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String deviceAddress = "";
        if (null == params || !params.containsKey("device_address") || null == params.get("device_address")) {
            throw new MissingParameter("device_address");
        }
        if (!this.isValidParameter(params.get("device_address")).booleanValue()) {
            throw new InvalidParameter("device_address");
        }
        deviceAddress = params.get("device_address").toString();
        params.remove("device_address");
        return OSTAPIService.specialCharacterEscape(deviceAddress);
    }

    public String getChainId(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String chainId = "";
        if (null == params || !params.containsKey("chain_id") || null == params.get("chain_id")) {
            throw new MissingParameter("chain_id");
        }
        if (!this.isValidParameter(params.get("chain_id")).booleanValue()) {
            throw new InvalidParameter("chain_id");
        }
        chainId = params.get("chain_id").toString();
        params.remove("chain_id");
        return OSTAPIService.specialCharacterEscape(chainId);
    }

    public String getTransactionId(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String transactionId = "";
        if (null == params || !params.containsKey("transaction_id") || null == params.get("transaction_id")) {
            throw new MissingParameter("transaction_id");
        }
        if (!this.isValidParameter(params.get("transaction_id")).booleanValue()) {
            throw new InvalidParameter("transaction_id");
        }
        transactionId = params.get("transaction_id").toString();
        params.remove("transaction_id");
        return OSTAPIService.specialCharacterEscape(transactionId);
    }

    public String getRecoveryOwnerAddress(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String recoveryOwnerAddress = "";
        if (null == params || !params.containsKey("recovery_owner_address") || null == params.get("recovery_owner_address")) {
            throw new MissingParameter("recovery_owner_address");
        }
        if (!this.isValidParameter(params.get("recovery_owner_address")).booleanValue()) {
            throw new InvalidParameter("recovery_owner_address");
        }
        recoveryOwnerAddress = params.get("recovery_owner_address").toString();
        params.remove("recovery_owner_address");
        return OSTAPIService.specialCharacterEscape(recoveryOwnerAddress);
    }

    public String getId(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String id = "";
        if (null == params || !params.containsKey("id") || null == params.get("id")) {
            throw new MissingParameter("id");
        }
        if (!this.isValidParameter(params.get("id")).booleanValue()) {
            throw new InvalidParameter("id");
        }
        id = params.get("id").toString();
        params.remove("id");
        return id;
    }

    public String getUserId(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String user_id = "";
        if (null == params || !params.containsKey("user_id") || null == params.get("user_id")) {
            throw new MissingParameter("user_id");
        }
        if (!this.isValidParameter(params.get("user_id")).booleanValue()) {
            throw new InvalidParameter("user_id");
        }
        user_id = params.get("user_id").toString();
        params.remove("user_id");
        return user_id;
    }

    public String getWebhookId(Map<String, Object> params) throws MissingParameter, InvalidParameter {
        String webhook_id = "";
        if (null == params || !params.containsKey("webhook_id") || null == params.get("webhook_id")) {
            throw new MissingParameter("webhook_id");
        }
        if (!this.isValidParameter(params.get("webhook_id")).booleanValue()) {
            throw new InvalidParameter("webhook_id");
        }
        webhook_id = params.get("webhook_id").toString();
        params.remove("webhook_id");
        return webhook_id;
    }

    public Boolean isValidParameter(Object params) throws InvalidParameter {
        if (params instanceof Number) {
            return true;
        }
        if (params instanceof String) {
            Pattern p = Pattern.compile("[0-9a-zA-Z.-]+");
            return p.matcher((String)params).matches();
        }
        return false;
    }

    private static String specialCharacterEscape(String stringToEscape) {
        stringToEscape = FormParameterEscaper.escape(stringToEscape);
        stringToEscape = stringToEscape.replace("*", "%26");
        return stringToEscape;
    }

    public class InvalidParameter
    extends Exception {
        public InvalidParameter(String paramName) {
            super(paramName + " is invalid");
        }
    }

    public class MissingParameter
    extends Exception {
        public MissingParameter(String paramName) {
            super(paramName + " missing in request params");
        }
    }
}

