/*
 * Decompiled with CFR 0.152.
 */
package com.ost.services;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ost.lib.OSTRequestClient;
import com.ost.services.OSTAPIService;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.ByteString;

public class Webhooks
extends OSTAPIService {
    private static String servicePrefix = "/webhooks";
    private static String serviceSuffix = "";
    private static final String HMAC_SHA256 = "HmacSHA256";

    public Webhooks(OSTRequestClient ostRequestClient) {
        super(ostRequestClient, servicePrefix, serviceSuffix);
    }

    public JsonObject create(Map<String, Object> params) throws IOException {
        String resource = this.urlPrefix + "/";
        return this.request.post(resource, params);
    }

    public JsonObject update(Map<String, Object> params) throws IOException, OSTAPIService.InvalidParameter, OSTAPIService.MissingParameter {
        String resource = this.urlPrefix + "/" + this.getWebhookId(params) + "/";
        return this.request.post(resource, params);
    }

    public JsonObject get(Map<String, Object> params) throws OSTAPIService.MissingParameter, IOException, OSTAPIService.InvalidParameter {
        String resource = this.urlPrefix + "/" + this.getWebhookId(params) + "/";
        return this.request.get(resource, params);
    }

    public JsonObject getList(Map<String, Object> params) throws IOException {
        String resource = this.urlPrefix + "/";
        return this.request.get(resource, params);
    }

    public JsonObject deleteWebhook(Map<String, Object> params) throws OSTAPIService.MissingParameter, OSTAPIService.InvalidParameter, IOException {
        String resource = this.urlPrefix + "/" + this.getWebhookId(params) + "/";
        return this.request.delete(resource, params);
    }

    public boolean verifySignature(String version, String stringifiedData, String requestTimestamp, String signature, String webhookSecret) {
        Mac mac;
        if (!(stringifiedData instanceof String)) {
            Gson gsonObj = new Gson();
            stringifiedData = gsonObj.toJson((Object)stringifiedData);
        }
        Buffer hmacInputBuffer = new Buffer();
        hmacInputBuffer.writeUtf8(requestTimestamp);
        hmacInputBuffer.writeByte(46);
        hmacInputBuffer.writeUtf8(version);
        hmacInputBuffer.writeByte(46);
        hmacInputBuffer.writeUtf8(stringifiedData);
        SecretKeySpec keySpec = new SecretKeySpec(webhookSecret.getBytes(Charsets.UTF_8), HMAC_SHA256);
        try {
            mac = Mac.getInstance(HMAC_SHA256);
            mac.init(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        byte[] bytes = hmacInputBuffer.readByteArray();
        byte[] result = mac.doFinal(bytes);
        String computedSignature = ByteString.of((byte[])result).hex();
        return signature.indexOf(computedSignature) >= 0;
    }
}

