/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Base {
    static final String VERSION = "1.0.1";
    public static final String CHARGE_URL = "https://api.paymentwall.com/api/pro/v1/charge";
    public static final String SUBS_URL = "https://api.paymentwall.com/api/pro/v1/subscription";
    public static final int API_VC = 1;
    public static final int API_GOODS = 2;
    public static final int API_CART = 3;
    public static final String CONTROLLER_PAYMENT_VIRTUAL_CURRENCY = "ps";
    public static final String CONTROLLER_PAYMENT_DIGITAL_GOODS = "subscription";
    public static final String CONTROLLER_PAYMENT_CART = "cart";
    public static final int DEFAULT_SIGNATURE_VERSION = 3;
    public static final int SIGNATURE_VERSION_1 = 1;
    public static final int SIGNATURE_VERSION_2 = 2;
    public static final int SIGNATURE_VERSION_3 = 3;
    protected ArrayList<String> errors = new ArrayList<String>(){
        {
            this.add("");
        }
    };
    static int apiType;
    static String appKey;
    static String secretKey;
    static String proApiKey;

    public static void setApiType(int apiType_) {
        apiType = apiType_;
    }

    public static int getApiType() {
        return apiType;
    }

    public static void setAppKey(String appKey_) {
        appKey = appKey_;
    }

    public static String getAppKey() {
        return appKey;
    }

    public static void setSecretKey(String secretKey_) {
        secretKey = secretKey_;
    }

    public static String getSecretKey() {
        return secretKey;
    }

    public static void setProApiKey(String proApiKey_) {
        proApiKey = proApiKey_;
    }

    public static String getProApiKey() {
        return proApiKey;
    }

    protected int appendToErrors(String err) {
        this.errors.add(err);
        return this.errors.size();
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public String getErrorSummary() {
        String listString = "";
        for (String s : this.errors) {
            listString = listString + s + "\n";
        }
        return listString;
    }

    public static double round(double value, int places) {
        if (places >= 0) {
            double factor = Math.pow(10.0, places);
            return (double)Math.round(value * factor) / factor;
        }
        throw new IllegalArgumentException("places should be more than or equals 0");
    }

    public static LinkedHashMap<String, ArrayList<String>> parseQuery(Map<String, String[]> _GET) {
        LinkedHashMap<String, ArrayList<String>> parameters = new LinkedHashMap<String, ArrayList<String>>();
        if (!_GET.isEmpty()) {
            for (Map.Entry<String, String[]> entry : _GET.entrySet()) {
                if (entry.getKey().contains("[") && entry.getKey().contains("]")) {
                    String key = Arrays.asList(entry.getKey().split("\\[\\d*\\]")).get(0);
                    ArrayList<Object> this_parameter_keys = new ArrayList<Object>();
                    if (parameters.containsKey(key)) {
                        this_parameter_keys.addAll((Collection)parameters.get(key));
                    }
                    this_parameter_keys.addAll(Arrays.asList((Object[])entry.getValue()));
                    parameters.put(key, this_parameter_keys);
                    continue;
                }
                parameters.put(entry.getKey(), new ArrayList<Object>(Arrays.asList((Object[])entry.getValue())));
            }
        }
        Set entries = parameters.entrySet();
        for (Map.Entry entry : entries) {
            ArrayList<String> values = new ArrayList<String>();
            for (String each : (ArrayList)entry.getValue()) {
                try {
                    values.add(URLDecoder.decode(each, "UTF-8"));
                    parameters.replace((String)entry.getKey(), values);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return parameters;
    }
}

