/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java;

import com.paymentwall.java.Base;
import com.paymentwall.java.Product;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Widget
extends Base {
    public final String BASE_URL = "https://api.paymentwall.com/api";
    protected String userId;
    protected String widgetCode;
    protected ArrayList<Product> products;
    protected LinkedHashMap<String, String> extraParams;

    public Widget(String userId_, String widgetCode_, ArrayList<Product> products_, LinkedHashMap<String, String> extraParams_) {
        this.userId = userId_;
        this.widgetCode = widgetCode_;
        this.products = products_;
        this.extraParams = extraParams_;
    }

    public int getDefaultSignatureVersion() {
        return Widget.getApiType() != 3 ? 3 : 2;
    }

    public String getUrl() {
        String signatureVersion;
        LinkedHashMap<String, ArrayList<String>> params = new LinkedHashMap<String, ArrayList<String>>();
        params.put("key", new ArrayList<String>(){
            {
                this.add(Base.getAppKey());
            }
        });
        params.put("uid", new ArrayList<String>(){
            {
                this.add(Widget.this.userId);
            }
        });
        params.put("widget", new ArrayList<String>(){
            {
                this.add(Widget.this.widgetCode);
            }
        });
        if (Widget.getApiType() == 2) {
            if (!this.products.isEmpty()) {
                if (this.products.size() == 1) {
                    Product postTrialProduct = null;
                    Product product = this.products.get(0);
                    if (product.getTrialProduct() != null) {
                        postTrialProduct = product;
                        product = postTrialProduct.getTrialProduct();
                    }
                    final Product finalproduct = product;
                    final Product product2 = postTrialProduct;
                    params.put("amount", new ArrayList<String>(){
                        {
                            this.add(Double.toString(finalproduct.getAmount()));
                        }
                    });
                    params.put("currencyCode", new ArrayList<String>(){
                        {
                            this.add(finalproduct.getCurrencyCode());
                        }
                    });
                    params.put("ag_name", new ArrayList<String>(){
                        {
                            this.add(finalproduct.getName());
                        }
                    });
                    params.put("ag_external_id", new ArrayList<String>(){
                        {
                            this.add(finalproduct.getId());
                        }
                    });
                    params.put("ag_type", new ArrayList<String>(){
                        {
                            this.add(finalproduct.getType());
                        }
                    });
                    if (product.getType().equals("subscription")) {
                        params.put("ag_period_length", new ArrayList<String>(){
                            {
                                this.add(Integer.toString(finalproduct.getPeriodLength()));
                            }
                        });
                        params.put("ag_period_type", new ArrayList<String>(){
                            {
                                this.add(finalproduct.getPeriodType());
                            }
                        });
                        if (product.isRecurring()) {
                            params.put("ag_recurring", new ArrayList<String>(){
                                {
                                    this.add("1");
                                }
                            });
                            if (product2 != null) {
                                params.put("ag_trial", new ArrayList<String>(){
                                    {
                                        this.add("1");
                                    }
                                });
                                params.put("ag_post_trial_external_id", new ArrayList<String>(){
                                    {
                                        this.add(product2.getId());
                                    }
                                });
                                params.put("ag_post_trial_period_length", new ArrayList<String>(){
                                    {
                                        this.add(Integer.toString(product2.getPeriodLength()));
                                    }
                                });
                                params.put("ag_post_trial_period_type", new ArrayList<String>(){
                                    {
                                        this.add(product2.getPeriodType());
                                    }
                                });
                                params.put("ag_post_trial_name", new ArrayList<String>(){
                                    {
                                        this.add(product2.getName());
                                    }
                                });
                                params.put("post_trial_amount", new ArrayList<String>(){
                                    {
                                        this.add(Double.toString(product2.getAmount()));
                                    }
                                });
                                params.put("post_trial_currencyCode", new ArrayList<String>(){
                                    {
                                        this.add(product2.getCurrencyCode());
                                    }
                                });
                            }
                        }
                    }
                } else {
                    this.appendToErrors("Only 1 product is allowed in flexible widget call");
                }
            }
        } else if (Widget.getApiType() == 3) {
            ArrayList<String> external_ids = new ArrayList<String>();
            ArrayList<String> prices = new ArrayList<String>();
            ArrayList currencies = new ArrayList();
            for (Product product : this.products) {
                external_ids.add(product.getId());
                if (product.getAmount() > 0.0) {
                    prices.add(Double.toString(product.getAmount()));
                }
                if (product.getCurrencyCode().equals("")) continue;
                currencies.add(product.getCurrencyCode());
            }
            params.put("external_ids", external_ids);
            params.put("prices", prices);
            params.put("currencies", currencies);
        }
        if (this.extraParams.containsKey("sign_version") && !this.extraParams.get("sign_version").isEmpty()) {
            params.put("sign_version", new ArrayList<String>(){
                {
                    this.add(Widget.this.extraParams.get("sign_version"));
                }
            });
            signatureVersion = this.extraParams.get("sign_version");
        } else {
            signatureVersion = Integer.toString(this.getDefaultSignatureVersion());
            params.put("sign_version", new ArrayList<String>(){
                {
                    this.add(Integer.toString(Widget.this.getDefaultSignatureVersion()));
                }
            });
        }
        TreeMap sortedParams = new TreeMap();
        for (final Map.Entry entry : this.extraParams.entrySet()) {
            params.put((String)entry.getKey(), new ArrayList<String>(){
                {
                    this.add(entry.getValue());
                }
            });
        }
        sortedParams.putAll(params);
        try {
            ArrayList<String> signature = new ArrayList<String>();
            signature.add(Widget.calculateSignature(params, Widget.getSecretKey(), Integer.parseInt(signatureVersion)));
            sortedParams.put("sign", signature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry entry : sortedParams.entrySet()) {
            if (((ArrayList)entry.getValue()).size() == 1) {
                arrayList.add(new BasicNameValuePair((String)entry.getKey(), (String)((ArrayList)entry.getValue()).get(0)));
                continue;
            }
            for (int i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                arrayList.add(new BasicNameValuePair((String)entry.getKey() + "[" + Integer.toString(i) + "]", (String)((ArrayList)entry.getValue()).get(i)));
            }
        }
        String baseString = URLEncodedUtils.format(arrayList, (String)"UTF-8");
        return "https://api.paymentwall.com/api/" + this.buildController(this.widgetCode) + "?" + baseString;
    }

    public String getHtmlCode(LinkedHashMap<String, String> attributes) {
        LinkedHashMap<String, String> defaultAttributes = new LinkedHashMap<String, String>();
        defaultAttributes.put("frameborder", "0");
        defaultAttributes.put("width", "750");
        defaultAttributes.put("height", "800");
        defaultAttributes.putAll(attributes);
        String attributesQuery = "";
        for (Map.Entry entry : defaultAttributes.entrySet()) {
            attributesQuery = attributesQuery + " " + (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"";
        }
        return "<iframe src=\"" + this.getUrl() + "\" " + attributesQuery + "></iframe>";
    }

    public String getHtmlCode() {
        return this.getHtmlCode(new LinkedHashMap<String, String>());
    }

    protected String buildController(String widget, boolean flexibleCall) {
        switch (Widget.getApiType()) {
            case 1: {
                if (!widget.matches("^(w|s|mw).*")) {
                    return "ps";
                }
            }
            case 2: {
                if (!flexibleCall) {
                    if (!widget.matches("^(w|s|mw).*")) {
                        return "subscription";
                    }
                    return "";
                }
                return "subscription";
            }
        }
        return "cart";
    }

    protected String buildController(String widget) {
        return this.buildController(widget, false);
    }

    public static String calculateSignature(LinkedHashMap<String, ArrayList<String>> params, String secret, int version) throws NoSuchElementException {
        MessageDigest md;
        MessageDigest sha;
        String baseString = "";
        if (version == 1) {
            if (!params.containsKey("uid")) {
                throw new NoSuchElementException("No uid is present!");
            }
            baseString = baseString + (!params.get("uid").isEmpty() ? params.get("uid").get(0) : "");
            baseString = baseString + secret;
            return DigestUtils.md5Hex((String)baseString);
        }
        TreeMap<String, ArrayList<String>> sortedParams = new TreeMap<String, ArrayList<String>>();
        sortedParams.putAll(params);
        for (Map.Entry pair : sortedParams.entrySet()) {
            if (((ArrayList)pair.getValue()).size() == 1) {
                baseString = baseString + (String)pair.getKey() + "=" + (String)((ArrayList)pair.getValue()).get(0);
                continue;
            }
            for (int i = 0; i < ((ArrayList)pair.getValue()).size(); ++i) {
                baseString = baseString + (String)pair.getKey() + "[" + i + "]" + "=" + (String)((ArrayList)pair.getValue()).get(i);
            }
        }
        baseString = baseString + secret;
        try {
            sha = MessageDigest.getInstance("SHA-256");
            sha.update(baseString.getBytes("UTF-8"));
            md = MessageDigest.getInstance("MD5");
            md.update(baseString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        if (version == 3) {
            return String.format("%032X", new BigInteger(1, sha.digest())).toLowerCase();
        }
        return String.format("%032X", new BigInteger(1, md.digest())).toLowerCase();
    }
}

