/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java;

import com.paymentwall.java.Messages;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
extends Messages {
    static final String VERSION = "2.0.0";
    static final String API_BASE_URL = "https://api.paymentwall.com/api";
    public static final int API_VC = 1;
    public static final int API_GOODS = 2;
    public static final int API_CART = 3;
    protected int apiType;
    protected String publicKey;
    protected String privateKey;
    protected String apiBaseUrl = "https://api.paymentwall.com/api";
    private static final Config instance = new Config();

    protected Config() {
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public void setApiBaseUrl() {
        this.apiBaseUrl = "";
    }

    public void setApiBaseUrl(String url) {
        this.apiBaseUrl = url;
    }

    public int getLocalApiType() {
        return this.apiType;
    }

    public void setLocalApiType() {
        this.apiType = 0;
    }

    public void setLocalApiType(int apiType_) {
        this.apiType = apiType_;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey() {
        this.publicKey = "";
    }

    public void setPublicKey(String key) {
        this.publicKey = key;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey() {
        this.privateKey = "";
    }

    public void setPrivateKey(String key) {
        this.privateKey = key;
    }

    public String getVersion() {
        return VERSION;
    }

    public boolean isTest() {
        return this.getPublicKey().startsWith("t_") && this.getPrivateKey().startsWith("t_");
    }

    public void set(HashMap<String, String> config) {
        if (config.containsKey("api_base_url")) {
            this.setApiBaseUrl(config.get("api_base_url"));
        }
        if (config.containsKey("api_type")) {
            this.setLocalApiType(Integer.parseInt(config.get("api_type")));
        }
        if (config.containsKey("public_key")) {
            this.setPublicKey(config.get("public_key"));
        }
        if (config.containsKey("private_key")) {
            this.setPrivateKey(config.get("private_key"));
        }
    }

    public static Config getInstance() {
        return instance;
    }

    public static double round(double value, int places) {
        double factor = Math.pow(10.0, places);
        return (double)Math.round(value * factor) / factor;
    }

    public static HashMap<String, ArrayList<String>> parseQuery(Map<String, String[]> _GET) {
        final HashMap<String, ArrayList<String>> parameters = new HashMap<String, ArrayList<String>>();
        if (!_GET.isEmpty()) {
            for (final Map.Entry<String, String[]> entry : _GET.entrySet()) {
                String fixedKey = entry.getKey();
                if (entry.getKey().contains("[") && entry.getKey().contains("]")) {
                    fixedKey = entry.getKey().replaceFirst("\\[\\d*\\]", "");
                }
                final String finalFixedKey = fixedKey;
                parameters.put(fixedKey, new ArrayList<String>(){
                    {
                        for (String value : (String[])entry.getValue()) {
                            if (parameters.containsKey(finalFixedKey)) {
                                for (int i = 0; i < ((ArrayList)parameters.get(finalFixedKey)).size(); ++i) {
                                    this.add(this.size(), ((ArrayList)parameters.get(finalFixedKey)).get(i));
                                }
                            }
                            try {
                                this.add(this.size(), URLDecoder.decode(value, "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
        return parameters;
    }
}

