/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java;

import com.paymentwall.java.HttpAction;
import com.paymentwall.java.HttpActionBuilder;
import com.paymentwall.java.Instance;
import com.paymentwall.java.response.Factory;
import com.paymentwall.java.response.Interface;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApiObject
extends Instance {
    protected JSONObject properties = new JSONObject();
    protected String id;

    abstract String getEndpointName();

    protected ApiObject(String id) {
        this.id = id;
    }

    protected ApiObject() {
    }

    public ApiObject create(final HashMap<String, String> params) throws Exception {
        HttpActionBuilder httpActionBuilder = new HttpActionBuilder(this){
            {
                super(object);
                this.setParams(params);
                this.setHeaders(ApiObject.this.sList(ApiObject.this.getApiBaseHeader()));
            }
        };
        HttpAction httpAction = httpActionBuilder.build();
        this.setPropertiesFromResponse(httpAction.run());
        return this;
    }

    public String get(String property) {
        return this.properties.containsKey((Object)property) ? this.properties.get((Object)property).toString() : "";
    }

    public JSONObject getAsJSON(String property) {
        return (JSONObject)(this.properties.containsKey((Object)property) ? (this.properties.get((Object)property) != null ? this.properties.get((Object)property) : null) : null);
    }

    public boolean getAsBoolean(String property) {
        return this.get(property).equals("true");
    }

    public int getAsInt(String property) {
        return Integer.parseInt(this.get(property));
    }

    public String getApiUrl() {
        if (this.getEndpointName().equals("token") && !this.getConfig().isTest()) {
            return "https://pwgateway.com/api/token";
        }
        return this.getApiBaseUrl() + "/brick/" + this.getEndpointName();
    }

    public JSONObject getPublicData() {
        Interface responseModel = Factory.get(this.getPropertiesFromResponse());
        return responseModel.process();
    }

    protected void setPropertiesFromResponse(String response) throws Exception {
        if (response.isEmpty()) {
            throw new Exception("Empty response");
        }
        this.properties = this.preparePropertiesFromResponse(response);
    }

    protected JSONObject getPropertiesFromResponse() {
        return this.properties;
    }

    protected JSONObject preparePropertiesFromResponse(String response) throws ParseException {
        JSONParser parser = new JSONParser();
        return (JSONObject)parser.parse(response);
    }

    protected String getApiBaseHeader() {
        return "X-ApiKey: " + this.getPrivateKey();
    }

    protected ApiObject doApiAction(String action, Instance.httpMethod method) throws Exception {
        String actionUrl = this.getApiUrl() + "/" + this.id + "/" + action;
        HttpActionBuilder httpActionBuilder = new HttpActionBuilder(this);
        httpActionBuilder.setParams(new HashMap<String, String>(){
            {
                this.put("id", ApiObject.this.id);
            }
        });
        httpActionBuilder.setHeaders(this.sList(this.getApiBaseHeader()));
        HttpAction httpAction = httpActionBuilder.build();
        this.setPropertiesFromResponse(method.equals((Object)Instance.httpMethod.GET) ? httpAction.get(actionUrl) : httpAction.post(actionUrl));
        return this;
    }
}

