/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java;

import com.paymentwall.java.Instance;
import com.paymentwall.java.Product;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Widget
extends Instance {
    public final String BASE_URL = "https://api.paymentwall.com/api";
    protected String userId;
    protected String widgetCode;
    protected ArrayList<Product> products;
    protected HashMap<String, String> extraParams;

    public Widget(String userId, String widgetCode, ArrayList<Product> products, HashMap<String, String> extraParams) {
        this.userId = userId;
        this.widgetCode = widgetCode;
        this.products = products;
        this.extraParams = extraParams;
    }

    public void setExtraParams(HashMap<String, String> extraParams) {
        this.extraParams = extraParams;
    }

    public int getDefaultSignatureVersion() {
        return this.getApiType() == 3 ? 2 : 3;
    }

    public String getUrl() {
        int signatureVersion;
        HashMap<String, String> p;
        block9: {
            block8: {
                block10: {
                    p = new HashMap<String, String>();
                    p.put("key", this.getPublicKey());
                    p.put("uid", this.userId);
                    p.put("widget", this.widgetCode);
                    if (this.getApiType() != 2) break block8;
                    if (this.products.isEmpty()) break block9;
                    if (this.products.size() != 1) break block10;
                    Object postTrialProduct = null;
                    Object product = this.products.get(0);
                    if (((Product)product).getTrialProduct() != null) {
                        postTrialProduct = product;
                        product = ((Product)postTrialProduct).getTrialProduct();
                    }
                    Object finalProduct = product;
                    Object finalTrialProduct = postTrialProduct;
                    p.put("amount", Double.toString(((Product)finalProduct).getAmount()));
                    p.put("currencyCode", ((Product)finalProduct).getCurrencyCode());
                    p.put("ag_name", ((Product)finalProduct).getName());
                    p.put("ag_external_id", ((Product)finalProduct).getId());
                    p.put("ag_type", ((Product)finalProduct).getType());
                    if (!((Product)product).getType().equals("subscription")) break block9;
                    p.put("ag_period_length", Integer.toString(((Product)finalProduct).getPeriodLength()));
                    p.put("ag_period_type", ((Product)finalProduct).getPeriodType());
                    if (!((Product)product).isRecurring()) break block9;
                    p.put("ag_recurring", "1");
                    if (finalTrialProduct == null) break block9;
                    p.put("ag_trial", "1");
                    p.put("ag_post_trial_external_id", ((Product)finalTrialProduct).getId());
                    p.put("ag_post_trial_period_length", Integer.toString(((Product)finalTrialProduct).getPeriodLength()));
                    p.put("ag_post_trial_period_type", ((Product)finalTrialProduct).getPeriodType());
                    p.put("ag_post_trial_name", ((Product)finalTrialProduct).getName());
                    p.put("post_trial_amount", Double.toString(((Product)finalTrialProduct).getAmount()));
                    p.put("post_trial_currencyCode", ((Product)finalTrialProduct).getCurrencyCode());
                    break block9;
                }
                this.appendToErrors("Only 1 product is allowed in flexible widget call");
                break block9;
            }
            if (this.getApiType() == 3) {
                int i = 0;
                for (Product product : this.products) {
                    p.put("external_ids[" + i + "]", product.getId());
                    if (product.getAmount() > 0.0) {
                        p.put("prices[" + i + "]", String.valueOf(product.getAmount()));
                    }
                    if (!product.getCurrencyCode().equals("")) {
                        p.put("currencies[" + i + "]", product.getCurrencyCode());
                    }
                    ++i;
                }
            }
        }
        if (this.extraParams.containsKey("sign_version") && !this.extraParams.get("sign_version").isEmpty()) {
            p.put("sign_version", this.extraParams.get("sign_version"));
            signatureVersion = Integer.parseInt(this.extraParams.get("sign_version"));
        } else {
            signatureVersion = this.getDefaultSignatureVersion();
            p.put("sign_version", Integer.toString(signatureVersion));
        }
        com.paymentwall.java.signature.Widget widgetSignatureModel = new com.paymentwall.java.signature.Widget();
        p.putAll(this.extraParams);
        p.put("sign", widgetSignatureModel.calculate(new LinkedHashMap<String, ArrayList<String>>(){
            {
                for (Map.Entry entry : p.entrySet()) {
                    this.put(entry.getKey(), Widget.this.sList((String)entry.getValue()));
                }
            }
        }, signatureVersion));
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry entry : p.entrySet()) {
            list.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        return "https://api.paymentwall.com/api/" + this.buildController(this.widgetCode) + "?" + URLEncodedUtils.format(list, (String)"UTF-8");
    }

    public String getHtmlCode(HashMap<String, String> attributes) {
        HashMap<String, String> defaultAttributes = new HashMap<String, String>();
        defaultAttributes.put("frameborder", "0");
        defaultAttributes.put("width", "750");
        defaultAttributes.put("height", "800");
        defaultAttributes.putAll(attributes);
        String attributesQuery = "";
        for (Map.Entry entry : defaultAttributes.entrySet()) {
            attributesQuery = attributesQuery + " " + (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"";
        }
        return "<iframe src=\"" + this.getUrl() + "\" " + attributesQuery + "></iframe>";
    }

    public String getHtmlCode() {
        return this.getHtmlCode(new HashMap<String, String>());
    }

    protected String buildController(String widget) {
        boolean isPaymentWidget;
        String controller = "";
        boolean bl = isPaymentWidget = !widget.matches("^(w|s|mw).*");
        if (this.getApiType() == 1) {
            if (isPaymentWidget) {
                controller = "ps";
            }
        } else {
            controller = this.getApiType() == 2 ? "subscription" : "cart";
        }
        return controller;
    }
}

