/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java;

import com.paymentwall.java.Base;
import com.paymentwall.java.Instance;
import com.paymentwall.java.Product;
import com.paymentwall.java.ProductBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.net.util.SubnetUtils;

public class Pingback
extends Instance {
    public final int PINGBACK_TYPE_REGULAR = 0;
    public final int PINGBACK_TYPE_GOODWILL = 1;
    public final int PINGBACK_TYPE_NEGATIVE = 2;
    public final int PINGBACK_TYPE_RISK_UNDER_REVIEW = 200;
    public final int PINGBACK_TYPE_RISK_REVIEWED_ACCEPTED = 201;
    public final int PINGBACK_TYPE_RISK_REVIEWED_DECLINED = 202;
    public final int PINGBACK_TYPE_RISK_AUTHORIZATION_VOIDED = 203;
    public final int PINGBACK_TYPE_SUBSCRIPTION_CANCELLATION = 12;
    public final int PINGBACK_TYPE_SUBSCRIPTION_EXPIRED = 13;
    public final int PINGBACK_TYPE_SUBSCRIPTION_PAYMENT_FAILED = 14;
    protected HashMap<String, ArrayList<String>> parameters = new HashMap();
    protected String ipAddress;

    public Pingback(Map<String, String[]> parameters, String ipAddress) {
        this.parameters = Base.parseQuery(parameters);
        this.ipAddress = ipAddress;
    }

    public boolean validate(boolean skipIpWhitelistCheck) {
        boolean validated = false;
        if (this.isParametersValid()) {
            if (this.isIpAddressValid() || skipIpWhitelistCheck) {
                if (this.isSignatureValid()) {
                    validated = true;
                } else {
                    this.appendToErrors("Wrong signature");
                }
            } else {
                this.appendToErrors("IP address is not whitelisted");
            }
        } else {
            this.appendToErrors("Missing parameters");
        }
        return validated;
    }

    public boolean validate() {
        return this.validate(false);
    }

    public boolean isSignatureValid() {
        ArrayList signatureParams;
        LinkedHashMap<String, ArrayList<String>> signatureParamsToSign = new LinkedHashMap<String, ArrayList<String>>();
        if (this.getApiType() == 1) {
            signatureParams = new ArrayList<String>(){
                {
                    this.add("uid");
                    this.add("currency");
                    this.add("type");
                    this.add("ref");
                }
            };
        } else if (this.getApiType() == 2) {
            signatureParams = new ArrayList<String>(){
                {
                    this.add("uid");
                    this.add("goodsid");
                    this.add("slength");
                    this.add("speriod");
                    this.add("type");
                    this.add("ref");
                }
            };
        } else {
            signatureParams = new ArrayList<String>(){
                {
                    this.add("uid");
                    this.add("goodsid");
                    this.add("type");
                    this.add("ref");
                }
            };
            this.parameters.put("sign_version", this.sList(Integer.toString(2)));
        }
        if (!this.parameters.containsKey("sign_version")) {
            this.parameters.put("sign_version", this.sList(Integer.toString(1)));
        }
        if (this.parameters.get("sign_version").isEmpty() || this.parameters.get("sign_version").get(0).equals("")) {
            this.parameters.put("sign_version", this.sList(Integer.toString(1)));
        }
        if (this.parameters.get("sign_version").get(0).equals(Integer.toString(1))) {
            Iterator iterator = signatureParams.iterator();
            while (iterator.hasNext()) {
                String field;
                signatureParamsToSign.put(field, this.parameters.containsKey(field = (String)iterator.next()) ? this.parameters.get(field) : this.sList(""));
            }
        } else {
            signatureParamsToSign.putAll(this.parameters);
        }
        com.paymentwall.java.signature.Pingback pingbackSignatureModel = new com.paymentwall.java.signature.Pingback();
        String signatureCalculated = pingbackSignatureModel.calculate(signatureParamsToSign, Integer.parseInt(this.parameters.get("sign_version").get(0)));
        String signature = this.parameters.containsKey("sig") ? this.parameters.get("sig").get(0) : "";
        return signature.equals(signatureCalculated);
    }

    public boolean isIpAddressValid() {
        ArrayList<String> ipsWhitelist = new ArrayList<String>();
        ipsWhitelist.add("174.36.92.186");
        ipsWhitelist.add("174.36.96.66");
        ipsWhitelist.add("174.36.92.187");
        ipsWhitelist.add("174.36.92.192");
        ipsWhitelist.add("174.37.14.28");
        SubnetUtils utils = new SubnetUtils("216.127.71.0/24");
        String[] allIps = utils.getInfo().getAllAddresses();
        for (int i = 0; i < allIps.length; ++i) {
            ipsWhitelist.add(allIps[i]);
        }
        return ipsWhitelist.contains(this.ipAddress);
    }

    public boolean isParametersValid() {
        ArrayList<String> requiredParams = new ArrayList<String>();
        requiredParams.add("uid");
        requiredParams.add("type");
        requiredParams.add("ref");
        requiredParams.add("sig");
        int errorsNumber = 0;
        if (this.getApiType() == 1) {
            requiredParams.add("currency");
        } else if (this.getApiType() == 2) {
            requiredParams.add("goodsid");
        } else {
            requiredParams.add("goodsid");
        }
        for (String field : requiredParams) {
            if (this.parameters.containsKey(field) && !this.parameters.get(field).isEmpty()) continue;
            this.appendToErrors("Parameter " + field + " is missing");
            ++errorsNumber;
        }
        return errorsNumber == 0;
    }

    public ArrayList<String> getParameter(String key) {
        if (this.parameters.containsKey(key)) {
            return this.parameters.get(key);
        }
        this.appendToErrors("Parameter " + key + " is missing");
        return this.sList("");
    }

    public int getType() {
        if (this.parameters.containsKey("type")) {
            return Integer.parseInt(this.parameters.get("type").get(0));
        }
        this.appendToErrors("Parameter type is missing");
        return 0;
    }

    public String getTypeVerbal() {
        HashMap<Integer, String> pingbackTypes = new HashMap<Integer, String>();
        pingbackTypes.put(12, "user_subscription_cancellation");
        pingbackTypes.put(13, "user_subscription_expired");
        pingbackTypes.put(14, "user_subscription_payment_failed");
        if (!this.parameters.get("type").isEmpty() && pingbackTypes.containsKey(Integer.parseInt(this.parameters.get("type").get(0)))) {
            return (String)pingbackTypes.get(Integer.parseInt(this.parameters.get("type").get(0)));
        }
        this.appendToErrors("Parameter type is missing");
        return "";
    }

    public String getUserId() {
        return this.getParameter("uid").get(0);
    }

    public Integer getVirtualCurrencyAmount() {
        return Integer.parseInt(this.getParameter("currency").get(0));
    }

    public String getProductId() {
        return this.getParameter("goodsid").get(0);
    }

    public int getProductPeriodLength() {
        try {
            return Integer.parseInt(this.getParameter("slength").get(0));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getProductPeriodType() {
        return this.getParameter("speriod").get(0);
    }

    public Product getProduct() {
        ProductBuilder a = new ProductBuilder(this.getProductId());
        a.setPeriodType(this.getProductPeriodType());
        a.setPeriodLength(this.getProductPeriodLength());
        a.setProductType(this.getProductPeriodLength() > 0 ? "subscription" : "fixed");
        return a.build();
    }

    public ArrayList<Product> getProducts() {
        ArrayList<Product> result = new ArrayList<Product>();
        ArrayList<String> productIds = new ArrayList<String>();
        if (!this.getParameter("goodsid").isEmpty()) {
            productIds.addAll(this.getParameter("goodsid"));
        }
        if (!productIds.isEmpty()) {
            for (String Id : productIds) {
                result.add(new ProductBuilder(Id).build());
            }
        }
        return result;
    }

    public String getReferenceId() {
        return this.getParameter("ref").get(0);
    }

    public String getPingbackUniqueId() {
        return this.getReferenceId() + "_" + this.getType();
    }

    public boolean isDeliverable() {
        switch (this.getType()) {
            case 1: {
                return true;
            }
            case 0: {
                return true;
            }
            case 201: {
                return true;
            }
        }
        return false;
    }

    public boolean isCancelable() {
        switch (this.getType()) {
            case 2: {
                return true;
            }
            case 202: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnderReview() {
        return this.getType() == 200;
    }
}

