/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java.utils;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Hasher {
    private static Hasher DEFAULT_HASHER = new Hasher(){
        private final String MD5 = "MD5";
        private final String SHA1 = "SHA-1";
        private final String SHA256 = "SHA-256";
        private final String UTF8 = "UTF-8";
        final char[] hexArray = "0123456789abcdef".toCharArray();

        @Override
        public byte[] md5(byte[] input) {
            return this.hash("MD5", input);
        }

        @Override
        public byte[] sha1(byte[] input) {
            return this.hash("SHA-1", input);
        }

        @Override
        public byte[] sha256(byte[] input) {
            return this.hash("SHA-256", input);
        }

        @Override
        public byte[] md5(String input) {
            return this.hash("MD5", input.getBytes(Charset.forName("UTF-8")));
        }

        @Override
        public byte[] sha1(String input) {
            return this.hash("SHA-1", input.getBytes(Charset.forName("UTF-8")));
        }

        @Override
        public byte[] sha256(String input) {
            return this.hash("SHA-256", input.getBytes(Charset.forName("UTF-8")));
        }

        @Override
        public String md5Hex(byte[] input) {
            return this.bytesToString(this.md5(input));
        }

        @Override
        public String sha1Hex(byte[] input) {
            return this.bytesToString(this.sha1(input));
        }

        @Override
        public String sha256Hex(byte[] input) {
            return this.bytesToString(this.sha256(input));
        }

        @Override
        public String md5Hex(String input) {
            return this.bytesToString(this.md5(input));
        }

        @Override
        public String sha1Hex(String input) {
            return this.bytesToString(this.sha1(input));
        }

        @Override
        public String sha256Hex(String input) {
            return this.bytesToString(this.sha256(input));
        }

        private byte[] hash(String messageDigestMethod, byte[] input) {
            try {
                MessageDigest md = MessageDigest.getInstance(messageDigestMethod);
                return md.digest(input);
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }

        public String bytesToString(byte[] bytes) {
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = this.hexArray[v >>> 4];
                hexChars[j * 2 + 1] = this.hexArray[v & 0xF];
            }
            return new String(hexChars);
        }
    };

    public abstract byte[] md5(byte[] var1);

    public abstract byte[] sha1(byte[] var1);

    public abstract byte[] sha256(byte[] var1);

    public abstract byte[] md5(String var1);

    public abstract byte[] sha1(String var1);

    public abstract byte[] sha256(String var1);

    public abstract String md5Hex(byte[] var1);

    public abstract String sha1Hex(byte[] var1);

    public abstract String sha256Hex(byte[] var1);

    public abstract String md5Hex(String var1);

    public abstract String sha1Hex(String var1);

    public abstract String sha256Hex(String var1);

    public static Hasher getDefault() {
        return DEFAULT_HASHER;
    }
}

