/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Point;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.path.Line;
import com.pdfdancer.common.model.path.Path;

public class LineBuilder {
    private final PDFDancer client;
    private final int pageIndex;
    private Point from;
    private Point to;
    private Color strokeColor;
    private Double strokeWidth;
    private double[] dashArray;
    private Double dashPhase;

    public LineBuilder(PDFDancer client, int pageIndex) {
        this.client = client;
        this.pageIndex = pageIndex;
    }

    public LineBuilder from(double x, double y) {
        this.from = new Point(x, y);
        return this;
    }

    public LineBuilder to(double x, double y) {
        this.to = new Point(x, y);
        return this;
    }

    public LineBuilder color(Color color) {
        this.strokeColor = color;
        return this;
    }

    public LineBuilder lineWidth(double width) {
        this.strokeWidth = width;
        return this;
    }

    public LineBuilder dash(double ... pattern) {
        this.dashArray = pattern;
        this.dashPhase = 0.0;
        return this;
    }

    public LineBuilder dashWithPhase(double phase, double ... pattern) {
        this.dashArray = pattern;
        this.dashPhase = phase;
        return this;
    }

    public boolean add() {
        if (this.from == null) {
            throw new IllegalArgumentException("Line start point (from) is not set");
        }
        if (this.to == null) {
            throw new IllegalArgumentException("Line end point (to) is not set");
        }
        Line line = new Line(this.from, this.to);
        if (this.strokeColor != null) {
            line.setStrokeColor(this.strokeColor);
        }
        if (this.strokeWidth != null) {
            line.setStrokeWidth(this.strokeWidth);
        }
        if (this.dashArray != null && this.dashArray.length > 0) {
            line.setDashArray(this.dashArray);
        }
        if (this.dashPhase != null) {
            line.setDashPhase(this.dashPhase);
        }
        line.setPosition(Position.atPageCoordinates(this.pageIndex, this.from.x(), this.from.y()));
        Path path = new Path();
        path.addPathSegment(line);
        return this.client.addObject(path);
    }
}

