/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model.path;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.Point;
import com.pdfdancer.common.model.path.PathSegment;

public class Bezier
extends PathSegment {
    private Point p0;
    private Point p1;
    private Point p2;
    private Point p3;

    public Bezier() {
    }

    @JsonCreator
    public Bezier(@JsonProperty(value="p0") Point p0, @JsonProperty(value="p1") Point p1, @JsonProperty(value="p2") Point p2, @JsonProperty(value="p3") Point p3) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    public Point evaluate(double t) {
        double x = Math.pow(1.0 - t, 3.0) * this.p0.x() + 3.0 * Math.pow(1.0 - t, 2.0) * t * this.p1.x() + 3.0 * (1.0 - t) * Math.pow(t, 2.0) * this.p2.x() + Math.pow(t, 3.0) * this.p3.x();
        double y = Math.pow(1.0 - t, 3.0) * this.p0.y() + 3.0 * Math.pow(1.0 - t, 2.0) * t * this.p1.y() + 3.0 * (1.0 - t) * Math.pow(t, 2.0) * this.p2.y() + Math.pow(t, 3.0) * this.p3.y();
        return new Point(x, y);
    }

    public Point getP0() {
        return this.p0;
    }

    public void setP0(Point p0) {
        this.p0 = p0;
    }

    public Point getP1() {
        return this.p1;
    }

    public void setP1(Point p1) {
        this.p1 = p1;
    }

    public Point getP2() {
        return this.p2;
    }

    public void setP2(Point p2) {
        this.p2 = p2;
    }

    public Point getP3() {
        return this.p3;
    }

    public void setP3(Point p3) {
        this.p3 = p3;
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.BEZIER;
    }
}

