/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Point;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.path.Bezier;
import com.pdfdancer.common.model.path.Path;

public class BezierBuilder {
    private final PDFDancer client;
    private final int pageIndex;
    private Point p0;
    private Point c1;
    private Point c2;
    private Point p3;
    private Color strokeColor;
    private Color fillColor;
    private Double strokeWidth;
    private double[] dashArray;
    private Double dashPhase;
    private Boolean evenOddFill;

    BezierBuilder(PDFDancer client, int pageIndex) {
        this.client = client;
        this.pageIndex = pageIndex;
    }

    public BezierBuilder from(double x, double y) {
        this.p0 = new Point(x, y);
        return this;
    }

    public BezierBuilder control1(double x, double y) {
        this.c1 = new Point(x, y);
        return this;
    }

    public BezierBuilder control2(double x, double y) {
        this.c2 = new Point(x, y);
        return this;
    }

    public BezierBuilder to(double x, double y) {
        this.p3 = new Point(x, y);
        return this;
    }

    public BezierBuilder color(Color color) {
        this.strokeColor = color;
        return this;
    }

    public BezierBuilder lineWidth(double width) {
        this.strokeWidth = width;
        return this;
    }

    public BezierBuilder fillColor(Color color) {
        this.fillColor = color;
        return this;
    }

    public BezierBuilder dash(double ... pattern) {
        this.dashArray = pattern;
        this.dashPhase = 0.0;
        return this;
    }

    public BezierBuilder dashWithPhase(double phase, double ... pattern) {
        this.dashArray = pattern;
        this.dashPhase = phase;
        return this;
    }

    public BezierBuilder evenOddFill(boolean evenOdd) {
        this.evenOddFill = evenOdd;
        return this;
    }

    public boolean add() {
        if (this.p0 == null) {
            throw new IllegalArgumentException("Bezier start point (from) is not set");
        }
        if (this.c1 == null) {
            throw new IllegalArgumentException("Bezier control1 is not set");
        }
        if (this.c2 == null) {
            throw new IllegalArgumentException("Bezier control2 is not set");
        }
        if (this.p3 == null) {
            throw new IllegalArgumentException("Bezier end point (to) is not set");
        }
        Bezier curve = new Bezier(this.p0, this.c1, this.c2, this.p3);
        if (this.strokeColor != null) {
            curve.setStrokeColor(this.strokeColor);
        }
        if (this.fillColor != null) {
            curve.setFillColor(this.fillColor);
        }
        if (this.strokeWidth != null) {
            curve.setStrokeWidth(this.strokeWidth);
        }
        if (this.dashArray != null && this.dashArray.length > 0) {
            curve.setDashArray(this.dashArray);
        }
        if (this.dashPhase != null) {
            curve.setDashPhase(this.dashPhase);
        }
        curve.setPosition(Position.atPageCoordinates(this.pageIndex, this.p0.x(), this.p0.y()));
        Path path = new Path();
        if (this.evenOddFill != null) {
            path.setEvenOddFill(this.evenOddFill);
        }
        path.addPathSegment(curve);
        return this.client.addObject(path);
    }
}

