/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.BezierBuilder;
import com.pdfdancer.client.rest.FormFieldReference;
import com.pdfdancer.client.rest.FormXObjectReference;
import com.pdfdancer.client.rest.ImageReference;
import com.pdfdancer.client.rest.LineBuilder;
import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.client.rest.PathBuilder;
import com.pdfdancer.client.rest.PathReference;
import com.pdfdancer.client.rest.TextLineReference;
import com.pdfdancer.client.rest.TextParagraphReference;
import com.pdfdancer.client.rest.TypedPageSnapshot;
import com.pdfdancer.common.model.FormFieldRef;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.PositionBuilder;
import com.pdfdancer.common.model.TextTypeObjectRef;
import com.pdfdancer.common.response.PageSnapshot;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PageApi {
    protected final PDFDancer root;
    protected final int pageIndex;

    public PageApi(PDFDancer root, int pageIndex) {
        this.root = root;
        this.pageIndex = pageIndex;
    }

    public List<TextParagraphReference> selectParagraphs() {
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "PARAGRAPH");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextObject(typed);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public List<TextParagraphReference> selectParagraphsStartingWith(String text) {
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "PARAGRAPH");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextObject(typed.stream().filter(ref -> this.root.startsWithIgnoreCase(ref.getText(), text)).collect(Collectors.toUnmodifiableList()));
    }

    public List<TextParagraphReference> selectParagraphsAt(double x, double y) {
        return this.selectParagraphsAt(x, y, 0.01);
    }

    public List<TextParagraphReference> selectParagraphsAt(double x, double y, double epsilon) {
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "PARAGRAPH");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextObject(typed.stream().filter(ref -> this.root.containsPoint((ObjectRef)ref, x, y, epsilon)).collect(Collectors.toUnmodifiableList()));
    }

    public Optional<TextParagraphReference> selectParagraphAt(double x, double y) {
        return this.selectParagraphAt(x, y, 0.01);
    }

    public Optional<TextParagraphReference> selectParagraphAt(double x, double y, double epsilon) {
        List<TextParagraphReference> paragraphs = this.selectParagraphsAt(x, y, epsilon);
        return paragraphs.isEmpty() ? Optional.empty() : Optional.of(paragraphs.get(0));
    }

    public List<TextParagraphReference> selectParagraphsMatching(String pattern) {
        Pattern compiled = Pattern.compile(pattern, 32);
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "PARAGRAPH");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextObject(typed.stream().filter(ref -> ref.getText() != null && compiled.matcher(ref.getText()).matches()).collect(Collectors.toUnmodifiableList()));
    }

    public List<PathReference> selectPathsAt(double x, double y) {
        Position position = new PositionBuilder().onPage(this.pageIndex).atCoordinates(x, y).build();
        return this.root.toPathObject(this.root.find(ObjectType.PATH, position));
    }

    public Optional<PathReference> selectPathAt(double x, double y) {
        List<PathReference> paths = this.selectPathsAt(x, y);
        return paths.isEmpty() ? Optional.empty() : Optional.of(paths.get(0));
    }

    public List<TextLineReference> selectTextLinesStartingWith(String text) {
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "TEXT_LINE");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextLineObject(typed.stream().filter(ref -> this.root.startsWithIgnoreCase(ref.getText(), text)).collect(Collectors.toUnmodifiableList()));
    }

    public List<TextLineReference> selectTextLinesAt(double x, double y) {
        return this.selectTextLinesAt(x, y, 0.01);
    }

    public List<TextLineReference> selectTextLines() {
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "TEXT_LINE");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextLineObject(typed);
    }

    public List<TextLineReference> selectTextLinesAt(double x, double y, double epsilon) {
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "TEXT_LINE");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextLineObject(typed.stream().filter(ref -> this.root.containsPoint((ObjectRef)ref, x, y, epsilon)).collect(Collectors.toUnmodifiableList()));
    }

    public Optional<TextLineReference> selectTextLineAt(double x, double y) {
        return this.selectTextLineAt(x, y, 0.01);
    }

    public Optional<TextLineReference> selectTextLineAt(double x, double y, double epsilon) {
        List<TextLineReference> textLines = this.selectTextLinesAt(x, y, epsilon);
        return textLines.isEmpty() ? Optional.empty() : Optional.of(textLines.get(0));
    }

    public List<TextLineReference> selectTextLinesMatching(String pattern) {
        Pattern compiled = Pattern.compile(pattern, 32);
        TypedPageSnapshot<TextTypeObjectRef> snapshot = this.root.getTypedPageSnapshot(this.pageIndex, TextTypeObjectRef.class, "TEXT_LINE");
        List<TextTypeObjectRef> typed = this.root.getTypedElements(snapshot, TextTypeObjectRef.class);
        return this.root.toTextLineObject(typed.stream().filter(ref -> ref.getText() != null && compiled.matcher(ref.getText()).matches()).collect(Collectors.toUnmodifiableList()));
    }

    public Optional<TextLineReference> selectTextLineMatching(String pattern) {
        List<TextLineReference> textLines = this.selectTextLinesMatching(pattern);
        return textLines.isEmpty() ? Optional.empty() : Optional.of(textLines.get(0));
    }

    public List<ImageReference> selectImages() {
        PageSnapshot snapshot = this.root.getPageSnapshotCached(this.pageIndex, null);
        List<ObjectRef> images = this.root.collectObjectsByType(snapshot, Set.of(ObjectType.IMAGE));
        return this.root.toImageObject(images);
    }

    public List<ImageReference> selectImagesAt(double x, double y) {
        return this.selectImagesAt(x, y, 0.01);
    }

    public List<ImageReference> selectImagesAt(double x, double y, double epsilon) {
        PageSnapshot snapshot = this.root.getPageSnapshotCached(this.pageIndex, null);
        List<ObjectRef> images = this.root.collectObjectsByType(snapshot, Set.of(ObjectType.IMAGE));
        List<ObjectRef> filtered = images.stream().filter(ref -> this.root.containsPoint((ObjectRef)ref, x, y, epsilon)).collect(Collectors.toUnmodifiableList());
        return this.root.toImageObject(filtered);
    }

    public Optional<ImageReference> selectImageAt(double x, double y) {
        return this.selectImageAt(x, y, 0.01);
    }

    public Optional<ImageReference> selectImageAt(double x, double y, double epsilon) {
        List<ImageReference> images = this.selectImagesAt(x, y, epsilon);
        return images.isEmpty() ? Optional.empty() : Optional.of(images.get(0));
    }

    public List<FormXObjectReference> selectForms() {
        PageSnapshot snapshot = this.root.getPageSnapshotCached(this.pageIndex, null);
        List<ObjectRef> forms = this.root.collectObjectsByType(snapshot, Set.of(ObjectType.FORM_X_OBJECT));
        return this.root.toFormXObject(forms);
    }

    public List<PathReference> selectPaths() {
        PageSnapshot snapshot = this.root.getPageSnapshotCached(this.pageIndex, null);
        List<ObjectRef> forms = this.root.collectObjectsByType(snapshot, Set.of(ObjectType.PATH));
        return this.root.toPathObject(forms);
    }

    public List<FormXObjectReference> selectFormsAt(double x, double y) {
        return this.selectFormsAt(x, y, 0.01);
    }

    public List<FormXObjectReference> selectFormsAt(double x, double y, double epsilon) {
        PageSnapshot snapshot = this.root.getPageSnapshotCached(this.pageIndex, null);
        List<ObjectRef> forms = this.root.collectObjectsByType(snapshot, Set.of(ObjectType.FORM_X_OBJECT));
        List<ObjectRef> filtered = forms.stream().filter(ref -> this.root.containsPoint((ObjectRef)ref, x, y, epsilon)).collect(Collectors.toUnmodifiableList());
        return this.root.toFormXObject(filtered);
    }

    public Optional<FormXObjectReference> selectFormAt(double x, double y) {
        return this.selectFormAt(x, y, 0.01);
    }

    public Optional<FormXObjectReference> selectFormAt(double x, double y, double epsilon) {
        List<FormXObjectReference> forms = this.selectFormsAt(x, y, epsilon);
        return forms.isEmpty() ? Optional.empty() : Optional.of(forms.get(0));
    }

    public List<FormFieldReference> selectFormFields() {
        List<FormFieldRef> formFields = this.root.collectFormFieldRefsFromPage(this.pageIndex);
        return this.root.toFormFieldObject(formFields);
    }

    public List<FormFieldReference> selectFormFieldsAt(double x, double y) {
        return this.selectFormFieldsAt(x, y, 0.01);
    }

    public List<FormFieldReference> selectFormFieldsAt(double x, double y, double epsilon) {
        List<FormFieldRef> formFields = this.root.collectFormFieldRefsFromPage(this.pageIndex);
        return this.root.toFormFieldObject(formFields.stream().filter(ref -> this.root.containsPoint((ObjectRef)ref, x, y, epsilon)).collect(Collectors.toUnmodifiableList()));
    }

    public Optional<FormFieldReference> selectFormFieldAt(double x, double y) {
        return this.selectFormFieldAt(x, y, 0.01);
    }

    public Optional<FormFieldReference> selectFormFieldAt(double x, double y, double epsilon) {
        List<FormFieldReference> formFields = this.selectFormFieldsAt(x, y, epsilon);
        return formFields.isEmpty() ? Optional.empty() : Optional.of(formFields.get(0));
    }

    public List<TextParagraphReference> selectTextStartingWith(String text) {
        return this.selectParagraphsStartingWith(text);
    }

    public BezierBuilder newBezier() {
        return new BezierBuilder(this.root, this.pageIndex);
    }

    public PathBuilder newPath() {
        return new PathBuilder(this.root, this.pageIndex);
    }

    public LineBuilder newLine() {
        return new LineBuilder(this.root, this.pageIndex);
    }
}

