/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class FileVersioner {
    private static Path ensureExtension(Path path, String extension) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            fileName = fileName.substring(0, dotIndex);
        }
        String newFileName = fileName + extension;
        Path parent = path.getParent();
        return parent == null ? Path.of(newFileName, new String[0]) : parent.resolve(newFileName);
    }

    public static Path getNextVersion(Path directory, File baselineFile) throws IOException {
        int maxVersion = FileVersioner.getMaxVersion(directory, baselineFile);
        int nextVersion = maxVersion == -1 ? 0 : maxVersion + 1;
        String nextName = FileVersioner.getVersionedName(baselineFile.getName(), nextVersion);
        return FileVersioner.ensureExtension(directory.resolve(nextName), ".client");
    }

    public static Path getNextXmlVersion(Path directory, File baselineFile) throws IOException {
        int maxVersion = FileVersioner.getMaxVersion(directory, baselineFile);
        int nextVersion = maxVersion == -1 ? 0 : maxVersion + 1;
        String nextName = FileVersioner.getVersionedName(baselineFile.getName(), nextVersion);
        return FileVersioner.ensureExtension(directory.resolve(nextName), ".xml");
    }

    public static Path getCurrentVersion(Path directory, File baselineFile) throws IOException {
        int maxVersion = FileVersioner.getMaxVersion(directory, baselineFile);
        if (maxVersion == -1) {
            return baselineFile.toPath();
        }
        String currentName = FileVersioner.getVersionedName(baselineFile.getName(), maxVersion);
        return directory.resolve(currentName);
    }

    private static int getMaxVersion(Path directory, File baselineFile) throws IOException {
        if (directory == null || !Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Invalid directory: " + String.valueOf(directory));
        }
        if (baselineFile == null || !baselineFile.getName().contains(".")) {
            throw new IllegalArgumentException("Invalid baseline file: " + String.valueOf(baselineFile));
        }
        String filename = baselineFile.getName();
        int dotIndex = filename.lastIndexOf(46);
        String baseName = filename.substring(0, dotIndex);
        String extension = filename.substring(dotIndex);
        String regex = Pattern.quote(baseName) + "(?:-(\\d+))?" + Pattern.quote(extension);
        Pattern pattern = Pattern.compile(regex);
        int maxVersion = -1;
        try (Stream<Path> stream = Files.list(directory);){
            for (Path file : stream::iterator) {
                String name = file.getFileName().toString();
                Matcher matcher = pattern.matcher(name);
                if (!matcher.matches()) continue;
                if (matcher.group(1) != null) {
                    int version = Integer.parseInt(matcher.group(1));
                    maxVersion = Math.max(maxVersion, version);
                    continue;
                }
                maxVersion = Math.max(maxVersion, 0);
            }
        }
        return maxVersion;
    }

    private static String getVersionedName(String filename, int version) {
        if (version == 0) {
            return filename;
        }
        int dotIndex = filename.lastIndexOf(46);
        String baseName = filename.substring(0, dotIndex);
        String extension = filename.substring(dotIndex);
        return baseName + "-" + version + extension;
    }
}

