/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.http;

import java.util.List;
import java.util.Objects;

public final class Argument<T> {
    private final Class<?> rawType;
    private final Class<?>[] typeArguments;

    private Argument(Class<?> rawType, Class<?> ... typeArguments) {
        this.rawType = Objects.requireNonNull(rawType, "rawType");
        this.typeArguments = typeArguments == null ? new Class[]{} : (Class[])typeArguments.clone();
    }

    public static <E> Argument<List<E>> listOf(Class<E> elementType) {
        return new Argument<List<E>>(List.class, elementType);
    }

    @SafeVarargs
    public static <T> Argument<T> of(Class<? super T> rawType, Class<?> ... typeArguments) {
        return new Argument<T>(rawType, typeArguments);
    }

    public Class<?> rawType() {
        return this.rawType;
    }

    public Class<?>[] typeArguments() {
        return (Class[])this.typeArguments.clone();
    }
}

