/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.pdfdancer.client.http.Argument;
import com.pdfdancer.client.http.MediaType;
import com.pdfdancer.client.http.MultipartBody;
import com.pdfdancer.client.http.MutableHttpRequest;
import com.pdfdancer.client.rest.PdfDancerClientException;
import com.pdfdancer.client.rest.RetryConfig;
import com.pdfdancer.common.model.ErrorResponse;
import com.pdfdancer.common.model.FontNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;

public final class PdfDancerHttpClient {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final HttpClient delegate;
    private final URI baseUrl;
    private final ObjectMapper objectMapper;
    private final RetryConfig retryConfig;

    private PdfDancerHttpClient(HttpClient delegate, URI baseUrl, ObjectMapper objectMapper, RetryConfig retryConfig) {
        this.delegate = delegate;
        this.baseUrl = baseUrl;
        this.objectMapper = objectMapper;
        this.retryConfig = retryConfig != null ? retryConfig : RetryConfig.defaultConfig();
    }

    public static PdfDancerHttpClient createDefault(URI baseUrl) {
        HttpClient client = HttpClient.newBuilder().connectTimeout(DEFAULT_TIMEOUT).build();
        return new PdfDancerHttpClient(client, baseUrl, PdfDancerHttpClient.createObjectMapper(), null);
    }

    public static PdfDancerHttpClient createDefault(URI baseUrl, RetryConfig retryConfig) {
        HttpClient client = HttpClient.newBuilder().connectTimeout(DEFAULT_TIMEOUT).build();
        return new PdfDancerHttpClient(client, baseUrl, PdfDancerHttpClient.createObjectMapper(), retryConfig);
    }

    public static PdfDancerHttpClient create(HttpClient httpClient, URI baseUrl) {
        return new PdfDancerHttpClient(httpClient, baseUrl, PdfDancerHttpClient.createObjectMapper(), null);
    }

    public static PdfDancerHttpClient create(HttpClient httpClient, URI baseUrl, ObjectMapper mapper) {
        return new PdfDancerHttpClient(httpClient, baseUrl, mapper == null ? PdfDancerHttpClient.createObjectMapper() : mapper, null);
    }

    public static PdfDancerHttpClient create(HttpClient httpClient, URI baseUrl, ObjectMapper mapper, RetryConfig retryConfig) {
        return new PdfDancerHttpClient(httpClient, baseUrl, mapper == null ? PdfDancerHttpClient.createObjectMapper() : mapper, retryConfig);
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new ParameterNamesModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public Blocking toBlocking() {
        return new Blocking();
    }

    /*
     * Exception decompiling
     */
    private <T> T send(MutableHttpRequest<?> request, Class<T> responseType, Argument<T> argument) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Duration calculateDelay(int attempt, int statusCode, HttpResponse<byte[]> response) {
        Duration retryDelay;
        Optional<String> retryAfter;
        if (statusCode == 429 && response != null && (retryAfter = response.headers().firstValue("Retry-After")).isPresent() && (retryDelay = this.parseRetryAfter(retryAfter.get())) != null) {
            if (retryDelay.compareTo(this.retryConfig.getMaxDelay()) > 0) {
                return this.retryConfig.getMaxDelay();
            }
            return retryDelay;
        }
        long delayMillis = (long)((double)this.retryConfig.getInitialDelay().toMillis() * Math.pow(this.retryConfig.getBackoffMultiplier(), attempt - 1));
        Duration delay = Duration.ofMillis(delayMillis);
        if (delay.compareTo(this.retryConfig.getMaxDelay()) > 0) {
            delay = this.retryConfig.getMaxDelay();
        }
        return delay;
    }

    private Duration parseRetryAfter(String retryAfterValue) {
        if (retryAfterValue == null || retryAfterValue.trim().isEmpty()) {
            return null;
        }
        String value = retryAfterValue.trim();
        try {
            long seconds = Long.parseLong(value);
            if (seconds >= 0L) {
                return Duration.ofSeconds(seconds);
            }
        }
        catch (NumberFormatException seconds) {
            // empty catch block
        }
        try {
            ZonedDateTime futureTime = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
            ZonedDateTime now = ZonedDateTime.now(ZoneId.of("GMT"));
            long secondsUntil = Duration.between(now, futureTime).getSeconds();
            if (secondsUntil >= 0L) {
                return Duration.ofSeconds(secondsUntil);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PdfDancerClientException("Retry sleep interrupted", e);
        }
    }

    private HttpRequest toJavaRequest(MutableHttpRequest<?> request) {
        URI target = this.baseUrl.resolve(request.path());
        HttpRequest.Builder builder = HttpRequest.newBuilder(target).timeout(DEFAULT_TIMEOUT);
        request.headers().forEach(builder::header);
        Object body = request.body();
        MediaType declaredContentType = request.contentType();
        if (body == null) {
            builder.method(request.method(), HttpRequest.BodyPublishers.noBody());
            return builder.build();
        }
        if (body instanceof byte[]) {
            if (declaredContentType != null) {
                builder.header("Content-Type", declaredContentType.value());
            }
            builder.method(request.method(), HttpRequest.BodyPublishers.ofByteArray((byte[])body));
            return builder.build();
        }
        if (body instanceof MultipartBody) {
            MultipartBody multipart = (MultipartBody)body;
            String boundary = multipart.boundary();
            String contentType = "multipart/form-data; boundary=" + boundary;
            builder.header("Content-Type", contentType);
            builder.method(request.method(), this.multipartPublisher(multipart));
            return builder.build();
        }
        byte[] json = this.writeJson(body);
        String contentType = declaredContentType != null ? declaredContentType.value() : MediaType.APPLICATION_JSON_TYPE.value();
        builder.header("Content-Type", contentType);
        builder.method(request.method(), HttpRequest.BodyPublishers.ofByteArray(json));
        return builder.build();
    }

    private HttpRequest.BodyPublisher multipartPublisher(MultipartBody multipart) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        String boundary = multipart.boundary();
        byte[] separator = ("--" + boundary + "\r\n").getBytes(StandardCharsets.UTF_8);
        byte[] closing = ("--" + boundary + "--\r\n").getBytes(StandardCharsets.UTF_8);
        for (MultipartBody.Part part : multipart.parts()) {
            byteArrays.add(separator);
            StringBuilder headers = new StringBuilder("Content-Disposition: form-data; name=\"").append(part.name()).append("\"");
            if (part.fileName() != null) {
                headers.append("; filename=\"").append(part.fileName()).append("\"");
            }
            headers.append("\r\nContent-Type: ").append(part.contentType().value()).append("\r\n\r\n");
            byteArrays.add(headers.toString().getBytes(StandardCharsets.UTF_8));
            byteArrays.add(part.content());
            byteArrays.add("\r\n".getBytes(StandardCharsets.UTF_8));
        }
        byteArrays.add(closing);
        return HttpRequest.BodyPublishers.ofByteArrays(byteArrays);
    }

    private RuntimeException translateError(HttpResponse<byte[]> response) {
        ErrorResponse err;
        int status = response.statusCode();
        byte[] body = response.body();
        Optional<ErrorResponse> error = this.parseError(body);
        if (status == 404 && error.isPresent() && "FontNotFoundException".equals((err = error.get()).error())) {
            return new FontNotFoundException(err.message());
        }
        String message = error.map(ErrorResponse::message).orElseGet(() -> "Unexpected HTTP status: " + status);
        return new PdfDancerClientException(status, message);
    }

    private Optional<ErrorResponse> parseError(byte[] body) {
        if (body == null || body.length == 0) {
            return Optional.empty();
        }
        try {
            return Optional.of((ErrorResponse)this.objectMapper.readValue(body, ErrorResponse.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private JavaType toJavaType(Argument<?> argument) {
        if (argument == null) {
            return this.objectMapper.getTypeFactory().constructType(Object.class);
        }
        Class<?> rawType = argument.rawType();
        Class[] typeArguments = argument.typeArguments();
        if (typeArguments.length == 0) {
            return this.objectMapper.getTypeFactory().constructType(rawType);
        }
        return this.objectMapper.getTypeFactory().constructParametricType(rawType, typeArguments);
    }

    private <T> T decode(byte[] body, Class<T> responseType) {
        if (responseType == Void.class || responseType == Void.TYPE) {
            return null;
        }
        if (responseType == byte[].class) {
            return (T)body;
        }
        if (responseType == String.class) {
            String cast = body == null ? null : new String(body, StandardCharsets.UTF_8);
            return (T)cast;
        }
        if (body == null || body.length == 0) {
            return null;
        }
        try {
            return responseType.cast(this.readValueFixingTypes(body, this.objectMapper.getTypeFactory().constructType(responseType)));
        }
        catch (IOException e) {
            String preview = new String(body, StandardCharsets.UTF_8);
            throw new PdfDancerClientException("Failed to parse response body: " + preview, e);
        }
    }

    private byte[] writeJson(Object body) {
        try {
            return this.objectMapper.writeValueAsBytes(body);
        }
        catch (JsonProcessingException e) {
            throw new PdfDancerClientException("Failed to serialize request body", e);
        }
    }

    private Object readValueFixingTypes(byte[] body, JavaType javaType) throws IOException {
        JsonNode node = this.objectMapper.readTree(body);
        this.ensureObjectRefType(node);
        return this.objectMapper.readerFor(javaType).readValue(node);
    }

    private void ensureObjectRefType(JsonNode node) {
        if (node == null) {
            return;
        }
        if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            if (!objectNode.has("type") && objectNode.has("objectRefType")) {
                objectNode.set("type", objectNode.get("objectRefType"));
            }
            if (!objectNode.has("objectRefType") && objectNode.has("type")) {
                objectNode.set("objectRefType", objectNode.get("type"));
            }
            objectNode.fields().forEachRemaining(entry -> this.ensureObjectRefType((JsonNode)entry.getValue()));
        } else if (node.isArray()) {
            node.forEach(this::ensureObjectRefType);
        }
    }

    public final class Blocking {
        public <T> T retrieve(MutableHttpRequest<?> request, Class<T> responseType) {
            return PdfDancerHttpClient.this.send(request, responseType, null);
        }

        public <T> T retrieve(MutableHttpRequest<?> request, Argument<T> argument) {
            return PdfDancerHttpClient.this.send(request, null, argument);
        }
    }
}

