/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ImageInfo {
    private final byte[] bytes;
    private final String format;
    private final int width;
    private final int height;

    public ImageInfo(byte[] bytes, String format, int width, int height) {
        this.bytes = bytes;
        this.format = format;
        this.width = width;
        this.height = height;
    }

    public static ImageInfo read(File file) throws IOException {
        byte[] imageBytes = Files.readAllBytes(file.toPath());
        BufferedImage img = ImageIO.read(file);
        if (img == null) {
            throw new IllegalArgumentException("Not a supported image file: " + String.valueOf(file));
        }
        int width = img.getWidth();
        int height = img.getHeight();
        int bufferedType = img.getType();
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                String formatName = reader.getFormatName();
                reader.dispose();
                ImageInfo imageInfo = new ImageInfo(imageBytes, formatName, width, height);
                return imageInfo;
            }
            throw new IllegalArgumentException("Not a supported image file: " + String.valueOf(file));
        }
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String format() {
        return this.format;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImageInfo that = (ImageInfo)obj;
        return Objects.equals(this.bytes, that.bytes) && Objects.equals(this.format, that.format) && this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        return Objects.hash(this.bytes, this.format, this.width, this.height);
    }

    public String toString() {
        return "ImageInfo[bytes=" + String.valueOf(this.bytes) + ", format=" + this.format + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

