/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.http.HttpRequest;
import com.pdfdancer.client.rest.DocumentSnapshotKey;
import com.pdfdancer.client.rest.PageSnapshotKey;
import com.pdfdancer.client.rest.PdfDancerHttpClient;
import com.pdfdancer.client.rest.SnapshotFetcher;
import com.pdfdancer.client.rest.TypedDocumentSnapshot;
import com.pdfdancer.client.rest.TypedPageSnapshot;
import com.pdfdancer.client.rest.TypedPageSnapshotKey;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.response.DocumentSnapshot;
import com.pdfdancer.common.response.PageSnapshot;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class SnapshotCache
implements SnapshotFetcher {
    private static final String ALL_TYPES_KEY = "__ALL__";
    private final String token;
    private final String sessionId;
    private final PdfDancerHttpClient.Blocking blockingClient;
    private final Map<String, DocumentSnapshot> documentSnapshotCache = new HashMap<String, DocumentSnapshot>();
    private final Map<PageSnapshotKey, PageSnapshot> pageSnapshotCache = new HashMap<PageSnapshotKey, PageSnapshot>();
    private final Map<DocumentSnapshotKey, TypedDocumentSnapshot<?>> typedDocumentSnapshotCache = new HashMap();
    private final Map<TypedPageSnapshotKey, TypedPageSnapshot<?>> typedPageSnapshotCache = new HashMap();

    SnapshotCache(String token, String sessionId, PdfDancerHttpClient.Blocking blockingClient) {
        this.token = token;
        this.sessionId = sessionId;
        this.blockingClient = blockingClient;
    }

    void invalidate() {
        this.documentSnapshotCache.clear();
        this.pageSnapshotCache.clear();
        this.typedDocumentSnapshotCache.clear();
        this.typedPageSnapshotCache.clear();
    }

    private String normalizeTypes(String types) {
        if (types == null || types.isBlank()) {
            return ALL_TYPES_KEY;
        }
        String normalized = Arrays.stream(types.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toUpperCase).sorted().collect(Collectors.joining(","));
        return normalized.isBlank() ? ALL_TYPES_KEY : normalized;
    }

    @Override
    public DocumentSnapshot fetchDocumentSnapshot(String types) {
        Object path = "/pdf/document/snapshot";
        if (types != null && !types.isBlank()) {
            path = (String)path + "?types=" + types;
        }
        return this.blockingClient.retrieve(HttpRequest.GET((String)path).bearerAuth(this.token).header("X-Session-Id", this.sessionId), DocumentSnapshot.class);
    }

    @Override
    public PageSnapshot fetchPageSnapshot(int pageNumber, String types) {
        String path = "/pdf/page/" + pageNumber + "/snapshot";
        if (types != null && !types.isBlank()) {
            path = path + "?types=" + types;
        }
        return this.blockingClient.retrieve(HttpRequest.GET(path).bearerAuth(this.token).header("X-Session-Id", this.sessionId), PageSnapshot.class);
    }

    @Override
    public <T extends ObjectRef> TypedDocumentSnapshot<T> fetchTypedDocumentSnapshot(Class<T> elementClass, String types) {
        Object path = "/pdf/document/snapshot";
        if (types != null && !types.isBlank()) {
            path = (String)path + "?types=" + types;
        }
        TypedDocumentSnapshot result = this.blockingClient.retrieve(HttpRequest.GET((String)path).bearerAuth(this.token).header("X-Session-Id", this.sessionId), TypedDocumentSnapshot.class);
        return result;
    }

    @Override
    public <T extends ObjectRef> TypedPageSnapshot<T> fetchTypedPageSnapshot(int pageNumber, Class<T> elementClass, String types) {
        String path = "/pdf/page/" + pageNumber + "/snapshot";
        if (types != null && !types.isBlank()) {
            path = path + "?types=" + types;
        }
        TypedPageSnapshot result = this.blockingClient.retrieve(HttpRequest.GET(path).bearerAuth(this.token).header("X-Session-Id", this.sessionId), TypedPageSnapshot.class);
        return result;
    }

    DocumentSnapshot getDocumentSnapshotCached(String types) {
        String key = this.normalizeTypes(types);
        DocumentSnapshot cached = this.documentSnapshotCache.get(key);
        if (cached != null) {
            return cached;
        }
        DocumentSnapshot snapshot = this.fetchDocumentSnapshot(types);
        this.documentSnapshotCache.put(key, snapshot);
        List<PageSnapshot> pages = snapshot.pages();
        for (int i = 0; i < pages.size(); ++i) {
            this.pageSnapshotCache.put(new PageSnapshotKey(i + 1, key), pages.get(i));
        }
        return snapshot;
    }

    PageSnapshot getPageSnapshotCached(int pageNumber, String types) {
        String key = this.normalizeTypes(types);
        PageSnapshotKey cacheKey = new PageSnapshotKey(pageNumber, key);
        PageSnapshot cached = this.pageSnapshotCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        PageSnapshot snapshot = this.fetchPageSnapshot(pageNumber, types);
        this.pageSnapshotCache.put(cacheKey, snapshot);
        return snapshot;
    }

    <T extends ObjectRef> TypedDocumentSnapshot<T> getTypedDocumentSnapshot(Class<T> elementClass, String types) {
        String key = this.normalizeTypes(types);
        DocumentSnapshotKey cacheKey = new DocumentSnapshotKey(elementClass, key);
        TypedDocumentSnapshot<?> cached = this.typedDocumentSnapshotCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        TypedDocumentSnapshot<T> snapshot = this.fetchTypedDocumentSnapshot(elementClass, types);
        this.typedDocumentSnapshotCache.put(cacheKey, snapshot);
        List<TypedPageSnapshot<T>> pages = snapshot.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            this.typedPageSnapshotCache.put(new TypedPageSnapshotKey(i + 1, elementClass, key), pages.get(i));
        }
        return snapshot;
    }

    <T extends ObjectRef> TypedPageSnapshot<T> getTypedPageSnapshot(int pageNumber, Class<T> elementClass, String types) {
        String key = this.normalizeTypes(types);
        TypedPageSnapshotKey cacheKey = new TypedPageSnapshotKey(pageNumber, elementClass, key);
        TypedPageSnapshot<?> cached = this.typedPageSnapshotCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        TypedPageSnapshot<T> snapshot = this.fetchTypedPageSnapshot(pageNumber, elementClass, types);
        this.typedPageSnapshotCache.put(cacheKey, snapshot);
        return snapshot;
    }
}

