/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.BaseReference;
import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextTypeObjectRef;
import com.pdfdancer.common.model.text.TextLine;

public class TextLineReference
extends BaseReference {
    public TextLineReference(PDFDancer client, TextTypeObjectRef objectRef) {
        super(client, objectRef);
    }

    private TextTypeObjectRef ref() {
        return (TextTypeObjectRef)this.objectRef;
    }

    public String getText() {
        return this.ref().getText();
    }

    public String getFontName() {
        return this.ref().getFontName();
    }

    public Double getFontSize() {
        return this.ref().getFontSize();
    }

    public Color getColor() {
        return this.ref().getColor();
    }

    public TextLineEdit edit() {
        return new TextLineEdit(this.client, this.objectRef);
    }

    public static class TextLineEdit {
        private final PDFDancer client;
        private final TextTypeObjectRef ref;
        private String newText;
        private Font newFont;
        private Position newPosition;
        private Color newColor;

        public TextLineEdit(PDFDancer client, ObjectRef ref) {
            this.client = client;
            this.ref = (TextTypeObjectRef)ref;
        }

        public TextLineEdit replace(String newText) {
            this.newText = newText;
            return this;
        }

        public TextLineEdit font(String fontName, double fontSize) {
            this.newFont = new Font(fontName, fontSize);
            return this;
        }

        public TextLineEdit font(Font font) {
            this.newFont = font;
            return this;
        }

        public TextLineEdit moveTo(double x, double y) {
            this.newPosition = Position.atPageCoordinates(this.ref.getPosition().getPageNumber(), x, y);
            return this;
        }

        public TextLineEdit color(Color color) {
            this.newColor = color;
            return this;
        }

        public boolean apply() {
            if (this.newFont == null && this.newPosition == null && this.newColor == null) {
                String textToUse = this.newText != null ? this.newText : this.ref.getText();
                return this.client.modifyTextLine((ObjectRef)this.ref, textToUse);
            }
            String textToUse = this.newText != null ? this.newText : this.ref.getText();
            Font fontToUse = this.newFont != null ? this.newFont : new Font(this.ref.getFontName(), this.ref.getFontSize());
            Position positionToUse = this.newPosition != null ? this.newPosition : this.ref.getPosition();
            Color colorToUse = this.newColor != null ? this.newColor : this.ref.getColor();
            TextLine textLine = TextLine.fromText(textToUse, positionToUse, colorToUse, fontToUse, this.ref.getStatus());
            return this.client.modifyTextLine((ObjectRef)this.ref, textLine);
        }
    }
}

