/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static File writeBytesToFile(byte[] data, String filePath) throws IOException {
        File file = new File(filePath);
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
        }
        return file;
    }

    public static Path saveToFile(byte[] pdfData, Path sessionDir, String pdfFilename) throws IOException {
        Path filePath = sessionDir.resolve(pdfFilename);
        LOG.info("Saving PDF data to temporary file: {}", (Object)filePath);
        Files.write(filePath, pdfData, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        filePath.toFile().deleteOnExit();
        return filePath;
    }

    public static byte[] bufferedImageToBytes(BufferedImage image, String format) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format, baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static void copyFiles(String sourceDirName, String targetDirName, String globPattern) throws IOException {
        final Path sourceDir = Paths.get(sourceDirName, new String[0]);
        final Path targetDir = Paths.get(targetDirName, new String[0]);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + globPattern);
        Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relativePath = sourceDir.relativize(file);
                if (matcher.matches(relativePath)) {
                    Path targetFile = targetDir.resolve(relativePath);
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("Copied: " + String.valueOf(file) + " -> " + String.valueOf(targetFile));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

