/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Point;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.path.Bezier;
import com.pdfdancer.common.model.path.Line;
import com.pdfdancer.common.model.path.Path;
import com.pdfdancer.common.model.path.PathSegment;
import java.util.ArrayList;
import java.util.List;

public class PathBuilder {
    private final PDFDancer client;
    private final int pageNumber;
    private final List<PathSegment> segments = new ArrayList<PathSegment>();
    private Point current;
    private Point start;
    private Color strokeColor;
    private Color fillColor;
    private Double strokeWidth;
    private double[] dashArray;
    private Double dashPhase;
    private Boolean evenOddFill;

    PathBuilder(PDFDancer client, int pageNumber) {
        this.client = client;
        this.pageNumber = pageNumber;
    }

    public PathBuilder moveTo(double x, double y) {
        this.start = this.current = new Point(x, y);
        return this;
    }

    public PathBuilder lineTo(double x, double y) {
        if (this.current == null) {
            throw new IllegalStateException("Call moveTo() before lineTo()");
        }
        Point next = new Point(x, y);
        Line line = new Line(this.current, next);
        this.applyStyle(line);
        line.setPosition(Position.atPageCoordinates(this.pageNumber, this.current.x(), this.current.y()));
        this.segments.add(line);
        this.current = next;
        return this;
    }

    public PathBuilder bezierTo(double cx1, double cy1, double cx2, double cy2, double x, double y) {
        if (this.current == null) {
            throw new IllegalStateException("Call moveTo() before bezierTo()");
        }
        Point c1 = new Point(cx1, cy1);
        Point c2 = new Point(cx2, cy2);
        Point end = new Point(x, y);
        Bezier b = new Bezier(this.current, c1, c2, end);
        this.applyStyle(b);
        b.setPosition(Position.atPageCoordinates(this.pageNumber, this.current.x(), this.current.y()));
        this.segments.add(b);
        this.current = end;
        return this;
    }

    public PathBuilder color(Color color) {
        this.strokeColor = color;
        return this;
    }

    public PathBuilder fillColor(Color color) {
        this.fillColor = color;
        return this;
    }

    public PathBuilder lineWidth(double width) {
        this.strokeWidth = width;
        return this;
    }

    public PathBuilder dash(double ... pattern) {
        this.dashArray = pattern;
        this.dashPhase = 0.0;
        return this;
    }

    public PathBuilder dashWithPhase(double phase, double ... pattern) {
        this.dashArray = pattern;
        this.dashPhase = phase;
        return this;
    }

    public PathBuilder evenOddFill(boolean evenOdd) {
        this.evenOddFill = evenOdd;
        return this;
    }

    public boolean add() {
        if (this.segments.isEmpty()) {
            throw new IllegalStateException("No segments in path. Use moveTo()/lineTo()/bezierTo() to add segments.");
        }
        Path path = new Path();
        if (this.evenOddFill != null) {
            path.setEvenOddFill(this.evenOddFill);
        }
        for (PathSegment s : this.segments) {
            path.addPathSegment(s);
        }
        return this.client.addObject(path);
    }

    private void applyStyle(PathSegment seg) {
        if (this.strokeColor != null) {
            seg.setStrokeColor(this.strokeColor);
        }
        if (this.fillColor != null) {
            seg.setFillColor(this.fillColor);
        }
        if (this.strokeWidth != null) {
            seg.setStrokeWidth(this.strokeWidth);
        }
        if (this.dashArray != null && this.dashArray.length > 0) {
            seg.setDashArray(this.dashArray);
        }
        if (this.dashPhase != null) {
            seg.setDashPhase(this.dashPhase);
        }
    }

    public PathBuilder closePath() {
        if (this.current == null || this.start == null) {
            throw new IllegalStateException("Call moveTo() before closePath()");
        }
        if (this.current.x() != this.start.x() || this.current.y() != this.start.y()) {
            this.lineTo(this.start.x(), this.start.y());
        }
        this.current = this.start;
        return this;
    }

    public PathBuilder rect(double x, double y, double width, double height) {
        this.moveTo(x, y);
        this.lineTo(x + width, y);
        this.lineTo(x + width, y + height);
        this.lineTo(x, y + height);
        return this.closePath();
    }

    public PathBuilder circle(double cx, double cy, double r) {
        double k = 0.5522847498 * r;
        this.moveTo(cx, cy + r);
        this.bezierTo(cx + k, cy + r, cx + r, cy + k, cx + r, cy);
        this.bezierTo(cx + r, cy - k, cx + k, cy - r, cx, cy - r);
        this.bezierTo(cx - k, cy - r, cx - r, cy - k, cx - r, cy);
        this.bezierTo(cx - r, cy + k, cx - k, cy + r, cx, cy + r);
        return this.closePath();
    }
}

