/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class PageSize {
    public static final PageSize A0 = new PageSize("A0", 2384.0, 3370.0);
    public static final PageSize A1 = new PageSize("A1", 1684.0, 2384.0);
    public static final PageSize A2 = new PageSize("A2", 1191.0, 1684.0);
    public static final PageSize A3 = new PageSize("A3", 842.0, 1191.0);
    public static final PageSize A4 = new PageSize("A4", 595.0, 842.0);
    public static final PageSize A5 = new PageSize("A5", 420.0, 595.0);
    public static final PageSize A6 = new PageSize("A6", 298.0, 420.0);
    public static final PageSize B4 = new PageSize("B4", 709.0, 1001.0);
    public static final PageSize B5 = new PageSize("B5", 499.0, 709.0);
    public static final PageSize LETTER = new PageSize("LETTER", 612.0, 792.0);
    public static final PageSize LEGAL = new PageSize("LEGAL", 612.0, 1008.0);
    public static final PageSize TABLOID = new PageSize("TABLOID", 792.0, 1224.0);
    public static final PageSize EXECUTIVE = new PageSize("EXECUTIVE", 522.0, 756.0);
    public static final PageSize POSTCARD = new PageSize("POSTCARD", 288.0, 432.0);
    public static final PageSize INDEX_3X5 = new PageSize("INDEX_3X5", 216.0, 360.0);
    private String name;
    private double width;
    private double height;

    public PageSize() {
    }

    public PageSize(double width, double height) {
        this(null, width, height);
    }

    public PageSize(String name, double width, double height) {
        this.name = name;
        this.width = width;
        this.height = height;
    }

    public static PageSize custom(double width, double height) {
        return new PageSize(null, width, height);
    }

    public static PageSize of(double pageWidth, double pageHeight) {
        PageSize[] standardSizes;
        double tolerance = 0.5;
        for (PageSize standard : standardSizes = new PageSize[]{A0, A1, A2, A3, A4, A5, A6, B4, B5, LETTER, LEGAL, TABLOID, EXECUTIVE, POSTCARD, INDEX_3X5}) {
            if (Math.abs(standard.getWidth() - pageWidth) < 0.5 && Math.abs(standard.getHeight() - pageHeight) < 0.5) {
                return standard;
            }
            if (!(Math.abs(standard.getWidth() - pageHeight) < 0.5) || !(Math.abs(standard.getHeight() - pageWidth) < 0.5)) continue;
            return standard;
        }
        return PageSize.custom(pageWidth, pageHeight);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    @JsonIgnore
    public boolean isStandard() {
        return this.name != null;
    }

    @JsonIgnore
    public boolean isCustom() {
        return this.name == null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PageSize)) {
            return false;
        }
        PageSize pageSize = (PageSize)o;
        return Double.compare(this.width, pageSize.width) == 0 && Double.compare(this.height, pageSize.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height);
    }
}

