/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.http;

import com.pdfdancer.client.http.MediaType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class MutableHttpRequest<T> {
    private final String method;
    private final String path;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private T body;
    private MediaType contentType;

    MutableHttpRequest(String method, String path, T body) {
        this.method = Objects.requireNonNull(method, "method");
        this.path = Objects.requireNonNull(path, "path");
        this.body = body;
    }

    public MutableHttpRequest<T> contentType(MediaType mediaType) {
        this.contentType = mediaType;
        return this;
    }

    public MutableHttpRequest<T> bearerAuth(String token) {
        if (token != null && !token.isBlank()) {
            this.header("Authorization", "Bearer " + token);
        }
        return this;
    }

    public MutableHttpRequest<T> header(String name, String value) {
        if (name != null && value != null) {
            this.headers.put(name, value);
        }
        return this;
    }

    public MutableHttpRequest<T> body(T newBody) {
        this.body = newBody;
        return this;
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public T body() {
        return this.body;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public MediaType contentType() {
        return this.contentType;
    }
}

