/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.ReflowPreset;
import com.pdfdancer.common.request.TemplateReplaceRequest;
import com.pdfdancer.common.request.TemplateReplacement;
import java.util.ArrayList;
import java.util.List;

public class ReplaceBuilder {
    private final PDFDancer client;
    private final List<Entry> entries = new ArrayList<Entry>();
    private Integer pageIndex;
    private ReflowPreset reflowPreset;
    private String currentPlaceholder;
    private String currentText;
    private Font currentFont;
    private Color currentColor;

    ReplaceBuilder(PDFDancer client, String placeholder, String text) {
        this.client = client;
        this.currentPlaceholder = placeholder;
        this.currentText = text;
    }

    ReplaceBuilder(PDFDancer client, int pageNumber, String placeholder, String text) {
        this(client, placeholder, text);
        this.pageIndex = pageNumber - 1;
    }

    public ReplaceBuilder withFont(String name, double size) {
        this.currentFont = new Font(name, size);
        return this;
    }

    public ReplaceBuilder withFont(Font font) {
        this.currentFont = font;
        return this;
    }

    public ReplaceBuilder withColor(int r, int g, int b) {
        this.currentColor = new Color(r, g, b);
        return this;
    }

    public ReplaceBuilder withColor(Color color) {
        this.currentColor = color;
        return this;
    }

    public ReplaceBuilder withReflow(ReflowPreset preset) {
        this.reflowPreset = preset;
        return this;
    }

    public ReplaceBuilder onPage(int pageNumber) {
        this.pageIndex = pageNumber - 1;
        return this;
    }

    public ReplaceBuilder replace(String placeholder, String text) {
        this.commitCurrent();
        this.currentPlaceholder = placeholder;
        this.currentText = text;
        this.currentFont = null;
        this.currentColor = null;
        return this;
    }

    public boolean apply() {
        this.commitCurrent();
        ArrayList<TemplateReplacement> replacements = new ArrayList<TemplateReplacement>();
        for (Entry e : this.entries) {
            replacements.add(new TemplateReplacement(e.placeholder, e.text, e.font, e.color));
        }
        TemplateReplaceRequest request = new TemplateReplaceRequest(replacements, this.pageIndex, this.reflowPreset);
        return this.client.applyReplacements(request);
    }

    private void commitCurrent() {
        if (this.currentPlaceholder != null) {
            this.entries.add(new Entry(this.currentPlaceholder, this.currentText, this.currentFont, this.currentColor));
            this.currentPlaceholder = null;
        }
    }

    private static class Entry {
        final String placeholder;
        final String text;
        final Font font;
        final Color color;

        Entry(String placeholder, String text, Font font, Color color) {
            this.placeholder = placeholder;
            this.text = text;
            this.font = font;
            this.color = color;
        }
    }
}

