/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.geom.Point2D;
import java.util.Objects;

public final class Point {
    @JsonProperty(value="x")
    private final double x;
    @JsonProperty(value="y")
    private final double y;

    @JsonCreator
    public Point(@JsonProperty(value="x") double x, @JsonProperty(value="y") double y) {
        this.x = x;
        this.y = y;
    }

    public static Point fromPoint2D(Point2D p) {
        if (p == null) {
            throw new IllegalArgumentException("p cannot be null");
        }
        return new Point(p.getX(), p.getY());
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Point that = (Point)obj;
        return Double.doubleToLongBits(this.x) == Double.doubleToLongBits(that.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(that.y);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "Point[x=" + this.x + ", y=" + this.y + "]";
    }
}

