/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pdfdancer.common.model.Image;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.Size;

public final class ImageTransformRequest {
    @JsonProperty(value="objectRef")
    private final ObjectRef objectRef;
    @JsonProperty(value="transformType")
    private final TransformType transformType;
    @JsonProperty(value="newImage")
    private final Image newImage;
    @JsonProperty(value="scaleFactor")
    private final Double scaleFactor;
    @JsonProperty(value="targetSize")
    private final Size targetSize;
    @JsonProperty(value="preserveAspectRatio")
    private final Boolean preserveAspectRatio;
    @JsonProperty(value="rotationAngle")
    private final Double rotationAngle;
    @JsonProperty(value="cropLeft")
    private final Integer cropLeft;
    @JsonProperty(value="cropTop")
    private final Integer cropTop;
    @JsonProperty(value="cropRight")
    private final Integer cropRight;
    @JsonProperty(value="cropBottom")
    private final Integer cropBottom;
    @JsonProperty(value="opacity")
    private final Double opacity;
    @JsonProperty(value="flipDirection")
    private final FlipDirection flipDirection;

    @JsonCreator
    public ImageTransformRequest(@JsonProperty(value="objectRef") ObjectRef objectRef, @JsonProperty(value="transformType") TransformType transformType, @JsonProperty(value="newImage") Image newImage, @JsonProperty(value="scaleFactor") Double scaleFactor, @JsonProperty(value="targetSize") Size targetSize, @JsonProperty(value="preserveAspectRatio") Boolean preserveAspectRatio, @JsonProperty(value="rotationAngle") Double rotationAngle, @JsonProperty(value="cropLeft") Integer cropLeft, @JsonProperty(value="cropTop") Integer cropTop, @JsonProperty(value="cropRight") Integer cropRight, @JsonProperty(value="cropBottom") Integer cropBottom, @JsonProperty(value="opacity") Double opacity, @JsonProperty(value="flipDirection") FlipDirection flipDirection) {
        this.objectRef = objectRef;
        this.transformType = transformType;
        this.newImage = newImage;
        this.scaleFactor = scaleFactor;
        this.targetSize = targetSize;
        this.preserveAspectRatio = preserveAspectRatio;
        this.rotationAngle = rotationAngle;
        this.cropLeft = cropLeft;
        this.cropTop = cropTop;
        this.cropRight = cropRight;
        this.cropBottom = cropBottom;
        this.opacity = opacity;
        this.flipDirection = flipDirection;
    }

    public static Builder builder(ObjectRef objectRef) {
        return new Builder(objectRef);
    }

    public ObjectRef objectRef() {
        return this.objectRef;
    }

    public TransformType transformType() {
        return this.transformType;
    }

    public Image newImage() {
        return this.newImage;
    }

    public Double scaleFactor() {
        return this.scaleFactor;
    }

    public Size targetSize() {
        return this.targetSize;
    }

    public Boolean preserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public Double rotationAngle() {
        return this.rotationAngle;
    }

    public Integer cropLeft() {
        return this.cropLeft;
    }

    public Integer cropTop() {
        return this.cropTop;
    }

    public Integer cropRight() {
        return this.cropRight;
    }

    public Integer cropBottom() {
        return this.cropBottom;
    }

    public Double opacity() {
        return this.opacity;
    }

    public FlipDirection flipDirection() {
        return this.flipDirection;
    }

    public static class Builder {
        private final ObjectRef objectRef;
        private TransformType transformType;
        private Image newImage;
        private Double scaleFactor;
        private Size targetSize;
        private Boolean preserveAspectRatio;
        private Double rotationAngle;
        private Integer cropLeft;
        private Integer cropTop;
        private Integer cropRight;
        private Integer cropBottom;
        private Double opacity;
        private FlipDirection flipDirection;

        private Builder(ObjectRef objectRef) {
            this.objectRef = objectRef;
        }

        public Builder replace(Image newImage) {
            this.transformType = TransformType.REPLACE;
            this.newImage = newImage;
            return this;
        }

        public Builder scale(double scaleFactor) {
            this.transformType = TransformType.SCALE;
            this.scaleFactor = scaleFactor;
            return this;
        }

        public Builder scaleTo(Size targetSize) {
            return this.scaleTo(targetSize, true);
        }

        public Builder scaleTo(Size targetSize, boolean preserveAspectRatio) {
            this.transformType = TransformType.SCALE;
            this.targetSize = targetSize;
            this.preserveAspectRatio = preserveAspectRatio;
            return this;
        }

        public Builder scaleTo(double width, double height) {
            return this.scaleTo(new Size(width, height), false);
        }

        public Builder scaleTo(double width, double height, boolean preserveAspectRatio) {
            return this.scaleTo(new Size(width, height), preserveAspectRatio);
        }

        public Builder rotate(double angle) {
            this.transformType = TransformType.ROTATE;
            this.rotationAngle = angle;
            return this;
        }

        public Builder crop(int left, int top, int right, int bottom) {
            this.transformType = TransformType.CROP;
            this.cropLeft = left;
            this.cropTop = top;
            this.cropRight = right;
            this.cropBottom = bottom;
            return this;
        }

        public Builder opacity(double opacity) {
            this.transformType = TransformType.OPACITY;
            this.opacity = opacity;
            return this;
        }

        public Builder flip(FlipDirection direction) {
            this.transformType = TransformType.FLIP;
            this.flipDirection = direction;
            return this;
        }

        public Builder flipHorizontal() {
            return this.flip(FlipDirection.HORIZONTAL);
        }

        public Builder flipVertical() {
            return this.flip(FlipDirection.VERTICAL);
        }

        public Builder flipBoth() {
            return this.flip(FlipDirection.BOTH);
        }

        public ImageTransformRequest build() {
            if (this.transformType == null) {
                throw new IllegalStateException("Transform type must be specified");
            }
            return new ImageTransformRequest(this.objectRef, this.transformType, this.newImage, this.scaleFactor, this.targetSize, this.preserveAspectRatio, this.rotationAngle, this.cropLeft, this.cropTop, this.cropRight, this.cropBottom, this.opacity, this.flipDirection);
        }
    }

    public static enum FlipDirection {
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }

    public static enum TransformType {
        REPLACE,
        SCALE,
        ROTATE,
        CROP,
        OPACITY,
        FLIP;

    }
}

