/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import java.util.Objects;

public final class TemplateReplacement {
    @JsonProperty(value="placeholder")
    private final String placeholder;
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="font")
    private final Font font;
    @JsonProperty(value="color")
    private final Color color;

    @JsonCreator
    public TemplateReplacement(@JsonProperty(value="placeholder") String placeholder, @JsonProperty(value="text") String text, @JsonProperty(value="font") Font font, @JsonProperty(value="color") Color color) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.font = font;
        this.color = color;
    }

    public static TemplateReplacement of(String placeholder, String text) {
        return new TemplateReplacement(placeholder, text, null, null);
    }

    public static TemplateReplacement withFont(String placeholder, String text, Font font) {
        return new TemplateReplacement(placeholder, text, font, null);
    }

    public static TemplateReplacement withColor(String placeholder, String text, Color color) {
        return new TemplateReplacement(placeholder, text, null, color);
    }

    public static TemplateReplacement withFormatting(String placeholder, String text, Font font, Color color) {
        return new TemplateReplacement(placeholder, text, font, color);
    }

    public String placeholder() {
        return this.placeholder;
    }

    public String text() {
        return this.text;
    }

    public Font font() {
        return this.font;
    }

    public Color color() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TemplateReplacement that = (TemplateReplacement)obj;
        return Objects.equals(this.placeholder, that.placeholder) && Objects.equals(this.text, that.text) && Objects.equals(this.font, that.font) && Objects.equals(this.color, that.color);
    }

    public int hashCode() {
        return Objects.hash(this.placeholder, this.text, this.font, this.color);
    }

    public String toString() {
        return "TemplateReplacement[placeholder=" + this.placeholder + ", text=" + this.text + ", font=" + String.valueOf(this.font) + ", color=" + String.valueOf(this.color) + "]";
    }
}

