/*
 * Decompiled with CFR 0.152.
 */
package com.phaxio.resources;

import com.phaxio.restclient.entities.RestRequest;
import com.phaxio.services.Requests;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FaxFile {
    private Requests client;
    private int faxId;
    private String thumbnail;

    public void setClient(Requests client) {
        this.client = client;
    }

    public FaxFile(int faxId) {
        this(faxId, null);
    }

    public FaxFile(int faxId, String thumbnail) {
        this.faxId = faxId;
        this.thumbnail = thumbnail;
    }

    public File toFile(String name) throws IOException {
        File file = new File(name);
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.getBytes());
        return file;
    }

    public byte[] getBytes() {
        RestRequest request = new RestRequest();
        request.resource = "faxes/" + this.faxId + "/file";
        if (this.thumbnail != null) {
            request.addParameter("thumbnail", this.thumbnail);
        }
        return this.client.download(request);
    }

    public FaxFile smallJpeg() {
        FaxFile file = new FaxFile(this.faxId, "s");
        file.setClient(this.client);
        return file;
    }

    public FaxFile largeJpeg() {
        FaxFile file = new FaxFile(this.faxId, "l");
        file.setClient(this.client);
        return file;
    }

    public FaxFile pdf() {
        FaxFile file = new FaxFile(this.faxId);
        file.setClient(this.client);
        return file;
    }

    public void delete() {
        RestRequest request = new RestRequest();
        request.resource = "faxes/" + this.faxId + "/file";
        this.client.delete(request);
    }
}

