/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public final class CommonUtils {
    public static String calculateSha256(Object ... args) {
        List<String> listOfArgs = CommonUtils.convertArgsToList(args);
        String data = String.join((CharSequence)":", listOfArgs);
        return CommonUtils.shaHex(data, ShaAlgorithm.SHA256);
    }

    public static List<String> convertArgsToList(Object ... args) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object arg : args) {
            list.add(arg.toString());
        }
        return list;
    }

    public static String shaHex(String data, ShaAlgorithm algorithm) {
        switch (algorithm) {
            case SHA256: {
                return DigestUtils.sha256Hex((String)data);
            }
        }
        return data;
    }

    public static boolean isCallbackValid(String username, String password, String authorization) {
        String sha256hash = CommonUtils.calculateSha256(username, password);
        return Objects.equals(sha256hash, authorization);
    }

    private CommonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static enum ShaAlgorithm {
        SHA256;

    }
}

