/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.events.publisher;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.pg.common.events.models.BaseEvent;
import com.phonepe.sdk.pg.common.events.models.BulkEvent;
import com.phonepe.sdk.pg.common.events.publisher.EventPublisher;
import com.phonepe.sdk.pg.common.events.queue.EventQueue;
import com.phonepe.sdk.pg.common.http.HttpCommand;
import com.phonepe.sdk.pg.common.http.HttpHeaderPair;
import com.phonepe.sdk.pg.common.http.HttpMethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedEventPublisher
implements EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(QueuedEventPublisher.class);
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final EventQueue eventQueue;
    private final String hostUrl;
    private Supplier<String> authTokenSupplier;
    protected ScheduledExecutorService scheduler;

    public QueuedEventPublisher(ObjectMapper objectMapper, OkHttpClient okHttpClient, EventQueue eventQueue, String hostUrl) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.eventQueue = eventQueue;
        this.hostUrl = hostUrl;
    }

    @Override
    public void setAuthTokenSupplier(Supplier<String> authTokenSupplier) {
        this.authTokenSupplier = authTokenSupplier;
    }

    @Override
    public void startPublishingEvents(Supplier<String> authTokenSupplier) {
        this.setAuthTokenSupplier(authTokenSupplier);
        if (Objects.isNull(this.scheduler)) {
            this.scheduler = Executors.newScheduledThreadPool(1);
            this.scheduler.scheduleWithFixedDelay(this, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void send(BaseEvent event) {
        this.eventQueue.add(event);
    }

    private void sendBatchData() {
        try {
            if (this.eventQueue.isEmpty()) {
                return;
            }
            log.info("Queue Size {}", (Object)this.eventQueue.size());
            List<List<BaseEvent>> bulkEventBatch = this.createEventBatches();
            for (List<BaseEvent> sdkEventList : bulkEventBatch) {
                try {
                    this.sendBatchData(sdkEventList);
                }
                catch (Exception exception) {
                    log.error("Error occurred sending events batch to backend", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            log.error("Error occurred sending events batch to backend", (Throwable)exception);
        }
    }

    private List<List<BaseEvent>> createEventBatches() {
        BaseEvent event;
        int CUR_QUEUE_SIZE = this.eventQueue.size();
        ArrayList<List<BaseEvent>> bulkEventBatch = new ArrayList<List<BaseEvent>>();
        ArrayList<BaseEvent> currentBatch = new ArrayList<BaseEvent>();
        for (int numEventsProcessed = 0; numEventsProcessed < CUR_QUEUE_SIZE && !Objects.isNull(event = this.eventQueue.poll()); ++numEventsProcessed) {
            currentBatch.add(event);
            if (currentBatch.size() != 10) continue;
            bulkEventBatch.add(currentBatch);
            currentBatch = new ArrayList();
        }
        if (!currentBatch.isEmpty()) {
            bulkEventBatch.add(currentBatch);
        }
        return bulkEventBatch;
    }

    private List<HttpHeaderPair> getHeaders() {
        ArrayList<HttpHeaderPair> headers = new ArrayList<HttpHeaderPair>();
        headers.add(HttpHeaderPair.builder().key("Accept").value("application/json").build());
        headers.add(HttpHeaderPair.builder().key("Authorization").value(this.authTokenSupplier.get()).build());
        headers.add(HttpHeaderPair.builder().key("Content-Type").value("application/json").build());
        return headers;
    }

    private void sendBatchData(List<BaseEvent> sdkEventList) {
        BulkEvent bulkEvent = BulkEvent.builder().events(sdkEventList).build();
        List<HttpHeaderPair> headers = this.getHeaders();
        HttpCommand<Object, BulkEvent> httpCommand = this.buildHttpCommand(headers, bulkEvent);
        httpCommand.execute();
    }

    private HttpCommand<Object, BulkEvent> buildHttpCommand(List<HttpHeaderPair> headers, BulkEvent bulkEvent) {
        return HttpCommand.builder().methodName(HttpMethodType.POST).hostURL(this.hostUrl).url("/client/v1/backend/events/batch").client(this.okHttpClient).objectMapper(this.objectMapper).responseTypeReference(new TypeReference<Object>(){}).requestData(bulkEvent).encodingType("application/json").headers(headers).build();
    }

    @Override
    public void run() {
        this.sendBatchData();
    }

    public static QueuedEventPublisherBuilder builder() {
        return new QueuedEventPublisherBuilder();
    }

    public static class QueuedEventPublisherBuilder {
        private ObjectMapper objectMapper;
        private OkHttpClient okHttpClient;
        private EventQueue eventQueue;
        private String hostUrl;

        QueuedEventPublisherBuilder() {
        }

        public QueuedEventPublisherBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public QueuedEventPublisherBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public QueuedEventPublisherBuilder eventQueue(EventQueue eventQueue) {
            this.eventQueue = eventQueue;
            return this;
        }

        public QueuedEventPublisherBuilder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public QueuedEventPublisher build() {
            return new QueuedEventPublisher(this.objectMapper, this.okHttpClient, this.eventQueue, this.hostUrl);
        }

        public String toString() {
            return "QueuedEventPublisher.QueuedEventPublisherBuilder(objectMapper=" + String.valueOf(this.objectMapper) + ", okHttpClient=" + String.valueOf(this.okHttpClient) + ", eventQueue=" + String.valueOf(this.eventQueue) + ", hostUrl=" + this.hostUrl + ")";
        }
    }
}

