/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.exception;

import com.phonepe.sdk.pg.common.exception.BadRequest;
import com.phonepe.sdk.pg.common.exception.ExpectationFailed;
import com.phonepe.sdk.pg.common.exception.ForbiddenAccess;
import com.phonepe.sdk.pg.common.exception.ResourceConflict;
import com.phonepe.sdk.pg.common.exception.ResourceGone;
import com.phonepe.sdk.pg.common.exception.ResourceInvalid;
import com.phonepe.sdk.pg.common.exception.ResourceNotFound;
import com.phonepe.sdk.pg.common.exception.TooManyRequest;
import com.phonepe.sdk.pg.common.exception.UnauthorizedAccess;
import com.phonepe.sdk.pg.common.http.PhonePeResponse;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExceptionMapper {
    public static Map<Integer, Class<?>> codeToException = Stream.of(new AbstractMap.SimpleEntry<Integer, Class<BadRequest>>(400, BadRequest.class), new AbstractMap.SimpleEntry<Integer, Class<UnauthorizedAccess>>(401, UnauthorizedAccess.class), new AbstractMap.SimpleEntry<Integer, Class<ForbiddenAccess>>(403, ForbiddenAccess.class), new AbstractMap.SimpleEntry<Integer, Class<ResourceNotFound>>(404, ResourceNotFound.class), new AbstractMap.SimpleEntry<Integer, Class<ResourceConflict>>(409, ResourceConflict.class), new AbstractMap.SimpleEntry<Integer, Class<ResourceGone>>(410, ResourceGone.class), new AbstractMap.SimpleEntry<Integer, Class<ExpectationFailed>>(417, ExpectationFailed.class), new AbstractMap.SimpleEntry<Integer, Class<ResourceInvalid>>(422, ResourceInvalid.class), new AbstractMap.SimpleEntry<Integer, Class<TooManyRequest>>(429, TooManyRequest.class)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    public static void prepareCodeToException(int responseCode, String message, PhonePeResponse phonePeResponse) {
        Class<?> exceptionClass = codeToException.get(responseCode);
        throw (Throwable)exceptionClass.getDeclaredConstructor(Integer.class, String.class, PhonePeResponse.class).newInstance(responseCode, message, phonePeResponse);
    }
}

