/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.pg.common.exception.ClientError;
import com.phonepe.sdk.pg.common.exception.ExceptionMapper;
import com.phonepe.sdk.pg.common.exception.PhonePeException;
import com.phonepe.sdk.pg.common.exception.ServerError;
import com.phonepe.sdk.pg.common.http.HttpHeaderPair;
import com.phonepe.sdk.pg.common.http.HttpMethodType;
import com.phonepe.sdk.pg.common.http.PhonePeResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCommand<T, R> {
    private static final Logger log = LoggerFactory.getLogger(HttpCommand.class);
    private final OkHttpClient client;
    @NotNull
    private final String hostURL;
    @NotNull
    private String url;
    private List<HttpHeaderPair> headers;
    private final ObjectMapper objectMapper;
    private final TypeReference<T> responseTypeReference;
    private final R requestData;
    private final String encodingType;
    @NotBlank
    private final HttpMethodType methodName;
    private Map<String, String> queryParams;

    private RequestBody prepareRequestBody() {
        if (Objects.equals(this.encodingType, "application/json")) {
            return RequestBody.create((byte[])this.objectMapper.writeValueAsBytes(this.requestData), (MediaType)MediaType.parse((String)this.encodingType));
        }
        if (Objects.equals(this.encodingType, "application/x-www-form-urlencoded")) {
            return (RequestBody)this.requestData;
        }
        return (RequestBody)this.requestData;
    }

    private HttpUrl prepareHttpURL(String url) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)String.format("%s%s", this.hostURL, url))).newBuilder();
        if (!Objects.isNull(this.queryParams)) {
            for (Map.Entry<String, String> param : this.queryParams.entrySet()) {
                urlBuilder.addQueryParameter(param.getKey(), param.getValue());
            }
        }
        return HttpUrl.get((String)urlBuilder.build().toString());
    }

    public T execute() {
        log.info("Calling {} : {}{}", new Object[]{this.methodName, this.hostURL, this.url});
        HttpUrl httpUrl = this.prepareHttpURL(this.url);
        Request httpRequest = this.prepareRequest(httpUrl);
        Response response = this.client.newCall(httpRequest).execute();
        return this.handleResponse(response);
    }

    public T handleResponse(Response response) {
        byte[] responseBody;
        int responseCode = response.code();
        byte[] byArray = responseBody = Objects.nonNull(response.body()) ? response.body().bytes() : null;
        if (responseCode >= 200 && responseCode <= 299) {
            return (T)this.objectMapper.readValue(responseBody, this.responseTypeReference);
        }
        try {
            PhonePeResponse phonePeResponse = (PhonePeResponse)this.objectMapper.readValue(responseBody, PhonePeResponse.class);
            if (ExceptionMapper.codeToException.containsKey(responseCode)) {
                ExceptionMapper.prepareCodeToException(responseCode, response.message(), phonePeResponse);
            } else {
                if (responseCode >= 400 && responseCode <= 499) {
                    throw new ClientError(responseCode, response.message(), phonePeResponse);
                }
                if (responseCode >= 500 && responseCode <= 599) {
                    throw new ServerError(responseCode, response.message(), phonePeResponse);
                }
            }
            throw new PhonePeException(responseCode, response.message(), phonePeResponse);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new PhonePeException(responseCode, response.message());
        }
    }

    public Request prepareRequest(HttpUrl httpUrl) {
        if (this.methodName == HttpMethodType.POST) {
            Request.Builder requestBuilder = new Request.Builder().url(httpUrl).post(this.prepareRequestBody());
            if (!Objects.isNull(this.headers)) {
                for (HttpHeaderPair httpHeader : this.headers) {
                    requestBuilder.header(httpHeader.getKey(), httpHeader.getValue());
                }
            }
            return requestBuilder.build();
        }
        if (this.methodName == HttpMethodType.GET) {
            Request.Builder requestBuilder = new Request.Builder().url(httpUrl).get();
            if (!Objects.isNull(this.headers)) {
                for (HttpHeaderPair httpHeader : this.headers) {
                    requestBuilder.header(httpHeader.getKey(), httpHeader.getValue());
                }
            }
            return requestBuilder.build();
        }
        throw new PhonePeException(405, "Method Not Supported");
    }

    public static <T, R> HttpCommandBuilder<T, R> builder() {
        return new HttpCommandBuilder();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHeaders(List<HttpHeaderPair> headers) {
        this.headers = headers;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public HttpCommand(OkHttpClient client, String hostURL, String url, List<HttpHeaderPair> headers, ObjectMapper objectMapper, TypeReference<T> responseTypeReference, R requestData, String encodingType, HttpMethodType methodName, Map<String, String> queryParams) {
        this.client = client;
        this.hostURL = hostURL;
        this.url = url;
        this.headers = headers;
        this.objectMapper = objectMapper;
        this.responseTypeReference = responseTypeReference;
        this.requestData = requestData;
        this.encodingType = encodingType;
        this.methodName = methodName;
        this.queryParams = queryParams;
    }

    public static class HttpCommandBuilder<T, R> {
        private OkHttpClient client;
        private String hostURL;
        private String url;
        private List<HttpHeaderPair> headers;
        private ObjectMapper objectMapper;
        private TypeReference<T> responseTypeReference;
        private R requestData;
        private String encodingType;
        private HttpMethodType methodName;
        private Map<String, String> queryParams;

        HttpCommandBuilder() {
        }

        public HttpCommandBuilder<T, R> client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public HttpCommandBuilder<T, R> hostURL(String hostURL) {
            this.hostURL = hostURL;
            return this;
        }

        public HttpCommandBuilder<T, R> url(String url) {
            this.url = url;
            return this;
        }

        public HttpCommandBuilder<T, R> headers(List<HttpHeaderPair> headers) {
            this.headers = headers;
            return this;
        }

        public HttpCommandBuilder<T, R> objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public HttpCommandBuilder<T, R> responseTypeReference(TypeReference<T> responseTypeReference) {
            this.responseTypeReference = responseTypeReference;
            return this;
        }

        public HttpCommandBuilder<T, R> requestData(R requestData) {
            this.requestData = requestData;
            return this;
        }

        public HttpCommandBuilder<T, R> encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public HttpCommandBuilder<T, R> methodName(HttpMethodType methodName) {
            this.methodName = methodName;
            return this;
        }

        public HttpCommandBuilder<T, R> queryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public HttpCommand<T, R> build() {
            return new HttpCommand<T, R>(this.client, this.hostURL, this.url, this.headers, this.objectMapper, this.responseTypeReference, this.requestData, this.encodingType, this.methodName, this.queryParams);
        }

        public String toString() {
            return "HttpCommand.HttpCommandBuilder(client=" + String.valueOf(this.client) + ", hostURL=" + this.hostURL + ", url=" + this.url + ", headers=" + String.valueOf(this.headers) + ", objectMapper=" + String.valueOf(this.objectMapper) + ", responseTypeReference=" + String.valueOf(this.responseTypeReference) + ", requestData=" + String.valueOf(this.requestData) + ", encodingType=" + this.encodingType + ", methodName=" + String.valueOf((Object)this.methodName) + ", queryParams=" + String.valueOf(this.queryParams) + ")";
        }
    }
}

