/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.models.request;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RefundRequest {
    private String merchantRefundId;
    private String originalMerchantOrderId;
    private long amount;

    RefundRequest(String merchantRefundId, String originalMerchantOrderId, long amount) {
        this.merchantRefundId = merchantRefundId;
        this.originalMerchantOrderId = originalMerchantOrderId;
        this.amount = amount;
    }

    public static RefundRequestBuilder builder() {
        return new RefundRequestBuilder();
    }

    public String getMerchantRefundId() {
        return this.merchantRefundId;
    }

    public String getOriginalMerchantOrderId() {
        return this.originalMerchantOrderId;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setMerchantRefundId(String merchantRefundId) {
        this.merchantRefundId = merchantRefundId;
    }

    public void setOriginalMerchantOrderId(String originalMerchantOrderId) {
        this.originalMerchantOrderId = originalMerchantOrderId;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefundRequest)) {
            return false;
        }
        RefundRequest other = (RefundRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        String this$merchantRefundId = this.getMerchantRefundId();
        String other$merchantRefundId = other.getMerchantRefundId();
        if (this$merchantRefundId == null ? other$merchantRefundId != null : !this$merchantRefundId.equals(other$merchantRefundId)) {
            return false;
        }
        String this$originalMerchantOrderId = this.getOriginalMerchantOrderId();
        String other$originalMerchantOrderId = other.getOriginalMerchantOrderId();
        return !(this$originalMerchantOrderId == null ? other$originalMerchantOrderId != null : !this$originalMerchantOrderId.equals(other$originalMerchantOrderId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RefundRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        String $merchantRefundId = this.getMerchantRefundId();
        result = result * 59 + ($merchantRefundId == null ? 43 : $merchantRefundId.hashCode());
        String $originalMerchantOrderId = this.getOriginalMerchantOrderId();
        result = result * 59 + ($originalMerchantOrderId == null ? 43 : $originalMerchantOrderId.hashCode());
        return result;
    }

    public String toString() {
        return "RefundRequest(merchantRefundId=" + this.getMerchantRefundId() + ", originalMerchantOrderId=" + this.getOriginalMerchantOrderId() + ", amount=" + this.getAmount() + ")";
    }

    public static class RefundRequestBuilder {
        private String merchantRefundId;
        private String originalMerchantOrderId;
        private long amount;

        RefundRequestBuilder() {
        }

        public RefundRequestBuilder merchantRefundId(String merchantRefundId) {
            this.merchantRefundId = merchantRefundId;
            return this;
        }

        public RefundRequestBuilder originalMerchantOrderId(String originalMerchantOrderId) {
            this.originalMerchantOrderId = originalMerchantOrderId;
            return this;
        }

        public RefundRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public RefundRequest build() {
            return new RefundRequest(this.merchantRefundId, this.originalMerchantOrderId, this.amount);
        }

        public String toString() {
            return "RefundRequest.RefundRequestBuilder(merchantRefundId=" + this.merchantRefundId + ", originalMerchantOrderId=" + this.originalMerchantOrderId + ", amount=" + this.amount + ")";
        }
    }
}

