/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.models.request.instruments;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.PgV2InstrumentType;
import com.phonepe.sdk.pg.common.models.request.instruments.NewCardDetails;
import com.phonepe.sdk.pg.common.models.request.instruments.PaymentV2Instrument;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CardPaymentV2Instrument
extends PaymentV2Instrument {
    private String authMode;
    private NewCardDetails cardDetails;
    private boolean savedCard;
    private String merchantUserId;

    public CardPaymentV2Instrument(String authMode, String merchantUserId, NewCardDetails cardDetails, boolean savedCard) {
        super(PgV2InstrumentType.CARD);
        this.authMode = authMode;
        this.cardDetails = cardDetails;
        this.savedCard = savedCard;
        this.merchantUserId = merchantUserId;
    }

    public static CardPaymentV2InstrumentBuilder builder() {
        return new CardPaymentV2InstrumentBuilder();
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public NewCardDetails getCardDetails() {
        return this.cardDetails;
    }

    public boolean isSavedCard() {
        return this.savedCard;
    }

    public String getMerchantUserId() {
        return this.merchantUserId;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public void setCardDetails(NewCardDetails cardDetails) {
        this.cardDetails = cardDetails;
    }

    public void setSavedCard(boolean savedCard) {
        this.savedCard = savedCard;
    }

    public void setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
    }

    public String toString() {
        return "CardPaymentV2Instrument(authMode=" + this.getAuthMode() + ", cardDetails=" + String.valueOf(this.getCardDetails()) + ", savedCard=" + this.isSavedCard() + ", merchantUserId=" + this.getMerchantUserId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardPaymentV2Instrument)) {
            return false;
        }
        CardPaymentV2Instrument other = (CardPaymentV2Instrument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSavedCard() != other.isSavedCard()) {
            return false;
        }
        String this$authMode = this.getAuthMode();
        String other$authMode = other.getAuthMode();
        if (this$authMode == null ? other$authMode != null : !this$authMode.equals(other$authMode)) {
            return false;
        }
        NewCardDetails this$cardDetails = this.getCardDetails();
        NewCardDetails other$cardDetails = other.getCardDetails();
        if (this$cardDetails == null ? other$cardDetails != null : !((Object)this$cardDetails).equals(other$cardDetails)) {
            return false;
        }
        String this$merchantUserId = this.getMerchantUserId();
        String other$merchantUserId = other.getMerchantUserId();
        return !(this$merchantUserId == null ? other$merchantUserId != null : !this$merchantUserId.equals(other$merchantUserId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CardPaymentV2Instrument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSavedCard() ? 79 : 97);
        String $authMode = this.getAuthMode();
        result = result * 59 + ($authMode == null ? 43 : $authMode.hashCode());
        NewCardDetails $cardDetails = this.getCardDetails();
        result = result * 59 + ($cardDetails == null ? 43 : ((Object)$cardDetails).hashCode());
        String $merchantUserId = this.getMerchantUserId();
        result = result * 59 + ($merchantUserId == null ? 43 : $merchantUserId.hashCode());
        return result;
    }

    public static class CardPaymentV2InstrumentBuilder {
        private String authMode;
        private String merchantUserId;
        private NewCardDetails cardDetails;
        private boolean savedCard;

        CardPaymentV2InstrumentBuilder() {
        }

        public CardPaymentV2InstrumentBuilder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        public CardPaymentV2InstrumentBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public CardPaymentV2InstrumentBuilder cardDetails(NewCardDetails cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }

        public CardPaymentV2InstrumentBuilder savedCard(boolean savedCard) {
            this.savedCard = savedCard;
            return this;
        }

        public CardPaymentV2Instrument build() {
            return new CardPaymentV2Instrument(this.authMode, this.merchantUserId, this.cardDetails, this.savedCard);
        }

        public String toString() {
            return "CardPaymentV2Instrument.CardPaymentV2InstrumentBuilder(authMode=" + this.authMode + ", merchantUserId=" + this.merchantUserId + ", cardDetails=" + String.valueOf(this.cardDetails) + ", savedCard=" + this.savedCard + ")";
        }
    }
}

