/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.models.request.instruments;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.PgV2InstrumentType;
import com.phonepe.sdk.pg.common.models.request.instruments.PaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.TokenDetails;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TokenPaymentV2Instrument
extends PaymentV2Instrument {
    private String authMode;
    private TokenDetails tokenDetails;
    private String merchantUserId;

    public TokenPaymentV2Instrument(String authMode, TokenDetails tokenDetails, String merchantUserId) {
        super(PgV2InstrumentType.TOKEN);
        this.authMode = authMode;
        this.tokenDetails = tokenDetails;
        this.merchantUserId = merchantUserId;
    }

    public static TokenPaymentV2InstrumentBuilder builder() {
        return new TokenPaymentV2InstrumentBuilder();
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public TokenDetails getTokenDetails() {
        return this.tokenDetails;
    }

    public String getMerchantUserId() {
        return this.merchantUserId;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public void setTokenDetails(TokenDetails tokenDetails) {
        this.tokenDetails = tokenDetails;
    }

    public void setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
    }

    public String toString() {
        return "TokenPaymentV2Instrument(authMode=" + this.getAuthMode() + ", tokenDetails=" + String.valueOf(this.getTokenDetails()) + ", merchantUserId=" + this.getMerchantUserId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenPaymentV2Instrument)) {
            return false;
        }
        TokenPaymentV2Instrument other = (TokenPaymentV2Instrument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$authMode = this.getAuthMode();
        String other$authMode = other.getAuthMode();
        if (this$authMode == null ? other$authMode != null : !this$authMode.equals(other$authMode)) {
            return false;
        }
        TokenDetails this$tokenDetails = this.getTokenDetails();
        TokenDetails other$tokenDetails = other.getTokenDetails();
        if (this$tokenDetails == null ? other$tokenDetails != null : !((Object)this$tokenDetails).equals(other$tokenDetails)) {
            return false;
        }
        String this$merchantUserId = this.getMerchantUserId();
        String other$merchantUserId = other.getMerchantUserId();
        return !(this$merchantUserId == null ? other$merchantUserId != null : !this$merchantUserId.equals(other$merchantUserId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenPaymentV2Instrument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $authMode = this.getAuthMode();
        result = result * 59 + ($authMode == null ? 43 : $authMode.hashCode());
        TokenDetails $tokenDetails = this.getTokenDetails();
        result = result * 59 + ($tokenDetails == null ? 43 : ((Object)$tokenDetails).hashCode());
        String $merchantUserId = this.getMerchantUserId();
        result = result * 59 + ($merchantUserId == null ? 43 : $merchantUserId.hashCode());
        return result;
    }

    public static class TokenPaymentV2InstrumentBuilder {
        private String authMode;
        private TokenDetails tokenDetails;
        private String merchantUserId;

        TokenPaymentV2InstrumentBuilder() {
        }

        public TokenPaymentV2InstrumentBuilder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        public TokenPaymentV2InstrumentBuilder tokenDetails(TokenDetails tokenDetails) {
            this.tokenDetails = tokenDetails;
            return this;
        }

        public TokenPaymentV2InstrumentBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public TokenPaymentV2Instrument build() {
            return new TokenPaymentV2Instrument(this.authMode, this.tokenDetails, this.merchantUserId);
        }

        public String toString() {
            return "TokenPaymentV2Instrument.TokenPaymentV2InstrumentBuilder(authMode=" + this.authMode + ", tokenDetails=" + String.valueOf(this.tokenDetails) + ", merchantUserId=" + this.merchantUserId + ")";
        }
    }
}

