/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.tokenhandler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.pg.Env;
import com.phonepe.sdk.pg.common.configs.CredentialConfig;
import com.phonepe.sdk.pg.common.events.models.BaseEvent;
import com.phonepe.sdk.pg.common.events.models.enums.EventType;
import com.phonepe.sdk.pg.common.events.publisher.EventPublisher;
import com.phonepe.sdk.pg.common.http.HttpCommand;
import com.phonepe.sdk.pg.common.http.HttpHeaderPair;
import com.phonepe.sdk.pg.common.http.HttpMethodType;
import com.phonepe.sdk.pg.common.tokenhandler.OAuthResponse;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenService {
    private static final Logger log = LoggerFactory.getLogger(TokenService.class);
    private OkHttpClient okHttpClient;
    private ObjectMapper objectMapper;
    private CredentialConfig credentialConfig;
    private Env env;
    private OAuthResponse oAuthResponse;
    private EventPublisher eventPublisher;

    public TokenService(OkHttpClient okHttpClient, ObjectMapper objectMapper, CredentialConfig credentialConfig, Env env, EventPublisher eventPublisher) {
        this.okHttpClient = okHttpClient;
        this.objectMapper = objectMapper;
        this.credentialConfig = credentialConfig;
        this.env = env;
        this.eventPublisher = eventPublisher;
        this.eventPublisher.send(BaseEvent.buildInitClientEvent(EventType.TOKEN_SERVICE_INITIALIZED));
    }

    private List<HttpHeaderPair> prepareRequestHeaders() {
        return Arrays.asList(HttpHeaderPair.builder().key("Content-Type").value("application/x-www-form-urlencoded").build(), HttpHeaderPair.builder().key("Accept").value("application/json").build());
    }

    public String formatCachedToken() {
        return this.oAuthResponse.getTokenType() + " " + this.oAuthResponse.getAccessToken();
    }

    public long getCurrentTime() {
        return Instant.now().getEpochSecond();
    }

    public synchronized String getAuthToken() {
        if (this.isCachedTokenValid()) {
            log.debug("Returning cached token");
            return this.formatCachedToken();
        }
        try {
            this.setOAuthResponse(this.fetchTokenFromPhonePe());
        }
        catch (Exception exception) {
            if (Objects.isNull(this.oAuthResponse)) {
                log.error("No cached token, error occurred while fetching new token {}", (Object)exception.toString());
                throw exception;
            }
            log.info("Returning cached token, error occurred while fetching new token {}", (Object)exception.toString());
            this.eventPublisher.send(BaseEvent.buildOAuthEvent(this.getCurrentTime(), "/v1/oauth/token", EventType.OAUTH_FETCH_FAILED_USED_CACHED_TOKEN, exception, this.oAuthResponse.getIssuedAt(), this.oAuthResponse.getExpiresAt()));
        }
        return this.formatCachedToken();
    }

    private synchronized boolean isCachedTokenValid() {
        long reloadTime;
        if (Objects.isNull(this.oAuthResponse)) {
            return false;
        }
        long issuedAt = this.oAuthResponse.getIssuedAt();
        long expireAt = this.oAuthResponse.getExpiresAt();
        long currentTime = this.getCurrentTime();
        return currentTime < (reloadTime = issuedAt + (expireAt - issuedAt) / 2L);
    }

    public void forceRefreshToken() {
        log.debug("Force Refreshing Token");
        this.setOAuthResponse(this.fetchTokenFromPhonePe());
    }

    public synchronized OAuthResponse fetchTokenFromPhonePe() {
        FormBody formBody = this.prepareFormBody(this.credentialConfig);
        String url = "/v1/oauth/token";
        return HttpCommand.builder().client(this.okHttpClient).objectMapper(this.objectMapper).responseTypeReference(new TypeReference<OAuthResponse>(){}).methodName(HttpMethodType.POST).headers(this.prepareRequestHeaders()).requestData(formBody).hostURL(this.env.getOAuthHostUrl()).url("/v1/oauth/token").encodingType("application/x-www-form-urlencoded").build().execute();
    }

    private FormBody prepareFormBody(CredentialConfig credentialConfig) {
        return new FormBody.Builder().add("client_id", credentialConfig.getClientId()).add("client_secret", credentialConfig.getClientSecret()).add("grant_type", "client_credentials").add("client_version", String.valueOf(credentialConfig.getClientVersion())).build();
    }

    public void setOAuthResponse(OAuthResponse oAuthResponse) {
        this.oAuthResponse = oAuthResponse;
    }
}

