/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.payments.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.phonepe.sdk.pg.Env;
import com.phonepe.sdk.pg.common.BaseClient;
import com.phonepe.sdk.pg.common.CommonUtils;
import com.phonepe.sdk.pg.common.constants.Headers;
import com.phonepe.sdk.pg.common.events.models.BaseEvent;
import com.phonepe.sdk.pg.common.events.models.enums.EventState;
import com.phonepe.sdk.pg.common.events.models.enums.EventType;
import com.phonepe.sdk.pg.common.events.models.enums.FlowType;
import com.phonepe.sdk.pg.common.exception.PhonePeException;
import com.phonepe.sdk.pg.common.http.HttpHeaderPair;
import com.phonepe.sdk.pg.common.http.HttpMethodType;
import com.phonepe.sdk.pg.common.models.request.PgPaymentRequest;
import com.phonepe.sdk.pg.common.models.request.RefundRequest;
import com.phonepe.sdk.pg.common.models.response.CallbackResponse;
import com.phonepe.sdk.pg.common.models.response.OrderStatusResponse;
import com.phonepe.sdk.pg.common.models.response.PgPaymentResponse;
import com.phonepe.sdk.pg.common.models.response.RefundResponse;
import com.phonepe.sdk.pg.common.models.response.RefundStatusResponse;
import com.phonepe.sdk.pg.payments.v2.models.request.CreateSdkOrderRequest;
import com.phonepe.sdk.pg.payments.v2.models.response.CreateSdkOrderResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CustomCheckoutClient
extends BaseClient {
    private List<HttpHeaderPair> headers;

    private CustomCheckoutClient(String clientId, String clientSecret, Integer clientVersion, Env env, boolean shouldPublishEvents) {
        super(clientId, clientSecret, clientVersion, env, shouldPublishEvents);
        this.eventPublisher.send(BaseEvent.buildInitClientEvent(FlowType.PG, EventType.CUSTOM_CHECKOUT_CLIENT_INITIALIZED));
        this.prepareHeaders();
    }

    public static CustomCheckoutClient getInstance(String clientId, String clientSecret, Integer clientVersion, Env env) throws PhonePeException {
        return CustomCheckoutClient.getInstance(clientId, clientSecret, clientVersion, env, true);
    }

    public static CustomCheckoutClient getInstance(String clientId, String clientSecret, Integer clientVersion, Env env, boolean shouldPublishEvents) throws PhonePeException {
        boolean shouldPublishInProd = shouldPublishEvents && env == Env.PRODUCTION;
        return new CustomCheckoutClient(clientId, clientSecret, clientVersion, env, shouldPublishInProd);
    }

    public PgPaymentResponse pay(PgPaymentRequest pgPaymentRequest) {
        String url = "/payments/v2/pay";
        try {
            PgPaymentResponse pgPaymentResponse = this.requestViaAuthRefresh(HttpMethodType.POST, pgPaymentRequest, url, null, new TypeReference<PgPaymentResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildCustomCheckoutPayEvent(EventState.SUCCESS, pgPaymentRequest, url, EventType.PAY_SUCCESS));
            return pgPaymentResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildCustomCheckoutPayEvent(EventState.FAILED, pgPaymentRequest, url, EventType.PAY_FAILED, exception));
            throw exception;
        }
    }

    public OrderStatusResponse getOrderStatus(String merchantOrderId) {
        return this.getOrderStatus(merchantOrderId, false);
    }

    public OrderStatusResponse getOrderStatus(String merchantOrderId, boolean details) {
        String url = String.format("/payments/v2/order/%s/status", merchantOrderId);
        try {
            OrderStatusResponse orderStatusResponse = this.requestViaAuthRefresh(HttpMethodType.GET, null, url, Collections.singletonMap("details", Boolean.toString(details)), new TypeReference<OrderStatusResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildOrderStatusEvent(EventState.SUCCESS, merchantOrderId, url, FlowType.PG, EventType.ORDER_STATUS_SUCCESS));
            return orderStatusResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildOrderStatusEvent(EventState.FAILED, merchantOrderId, url, FlowType.PG, EventType.ORDER_STATUS_FAILED, exception));
            throw exception;
        }
    }

    public RefundResponse refund(RefundRequest refundRequest) {
        String url = "/payments/v2/refund";
        try {
            RefundResponse refundResponse = this.requestViaAuthRefresh(HttpMethodType.POST, refundRequest, url, null, new TypeReference<RefundResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildRefundEvent(EventState.SUCCESS, refundRequest, url, FlowType.PG, EventType.REFUND_SUCCESS));
            return refundResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildRefundEvent(EventState.FAILED, refundRequest, url, FlowType.PG, EventType.REFUND_FAILED, exception));
            throw exception;
        }
    }

    public CreateSdkOrderResponse createSdkOrder(CreateSdkOrderRequest createSdkOrderRequest) {
        String url = "/payments/v2/sdk/order";
        try {
            CreateSdkOrderResponse createSdkOrderResponse = this.requestViaAuthRefresh(HttpMethodType.POST, createSdkOrderRequest, url, null, new TypeReference<CreateSdkOrderResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildCreateSdkOrderEvent(EventState.SUCCESS, createSdkOrderRequest, url, FlowType.PG, EventType.CREATE_SDK_ORDER_SUCCESS));
            return createSdkOrderResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildCreateSdkOrderEvent(EventState.FAILED, createSdkOrderRequest, url, FlowType.PG, EventType.CREATE_SDK_ORDER_FAILED, exception));
            throw exception;
        }
    }

    public OrderStatusResponse getTransactionStatus(String transactionId) {
        String url = String.format("/payments/v2/transaction/%s/status", transactionId);
        try {
            OrderStatusResponse orderStatusResponse = this.requestViaAuthRefresh(HttpMethodType.GET, null, url, null, new TypeReference<OrderStatusResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildTransactionStatusEvent(EventState.SUCCESS, transactionId, url, FlowType.PG, EventType.TRANSACTION_STATUS_SUCCESS));
            return orderStatusResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildTransactionStatusEvent(EventState.FAILED, transactionId, url, FlowType.PG, EventType.TRANSACTION_STATUS_FAILED, exception));
            throw exception;
        }
    }

    public RefundStatusResponse getRefundStatus(String refundId) {
        String url = String.format("/payments/v2/refund/%s/status", refundId);
        try {
            RefundStatusResponse refundStatusResponse = this.requestViaAuthRefresh(HttpMethodType.GET, null, url, null, new TypeReference<RefundStatusResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildRefundStatusEvent(EventState.SUCCESS, refundId, url, FlowType.PG, EventType.REFUND_STATUS_SUCCESS));
            return refundStatusResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildRefundStatusEvent(EventState.FAILED, refundId, url, FlowType.PG, EventType.REFUND_STATUS_FAILED, exception));
            throw exception;
        }
    }

    public CallbackResponse validateCallback(String username, String password, String authorization, String responseBody) {
        if (!CommonUtils.isCallbackValid(username, password, authorization)) {
            throw new PhonePeException(417, "Invalid Callback");
        }
        try {
            return (CallbackResponse)this.getObjectMapper().readValue(responseBody, CallbackResponse.class);
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildCallbackSerializationFailedEvent(EventState.FAILED, FlowType.PG, EventType.CALLBACK_SERIALIZATION_FAILED, exception));
            throw exception;
        }
    }

    private void prepareHeaders() {
        this.headers = new ArrayList<HttpHeaderPair>();
        this.headers.add(HttpHeaderPair.builder().key("Content-Type").value("application/json").build());
        this.headers.add(HttpHeaderPair.builder().key("x-source").value("API").build());
        this.headers.add(HttpHeaderPair.builder().key("x-source-version").value("V2").build());
        this.headers.add(HttpHeaderPair.builder().key("x-source-platform").value("BACKEND_JAVA_SDK").build());
        this.headers.add(HttpHeaderPair.builder().key("x-source-platform-version").value(Headers.SDK_VERSION).build());
    }
}

