/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.payments.v2.models.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.MetaInfo;
import com.phonepe.sdk.pg.common.models.request.InstrumentConstraint;
import com.phonepe.sdk.pg.common.models.request.PaymentFlow;
import com.phonepe.sdk.pg.payments.v2.models.request.MerchantUrls;
import com.phonepe.sdk.pg.payments.v2.models.request.PaymentModeConfig;
import com.phonepe.sdk.pg.payments.v2.models.request.PgCheckoutPaymentFlow;
import com.phonepe.sdk.pg.payments.v2.models.request.PgPaymentFlow;
import java.util.List;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateSdkOrderRequest {
    private String merchantOrderId;
    private long amount;
    private MetaInfo metaInfo;
    private PaymentFlow paymentFlow;
    private Long expireAfter;
    private List<InstrumentConstraint> constraints;
    private Boolean disablePaymentRetry;

    public CreateSdkOrderRequest(long amount, @NotNull String merchantOrderId, MetaInfo metaInfo, String message, String redirectUrl, Long expireAfter, Boolean disablePaymentRetry, PaymentModeConfig paymentModeConfig) {
        this.merchantOrderId = merchantOrderId;
        this.amount = amount;
        this.metaInfo = metaInfo;
        this.expireAfter = expireAfter;
        this.disablePaymentRetry = disablePaymentRetry;
        MerchantUrls merchantUrls = MerchantUrls.builder().redirectUrl(redirectUrl).build();
        this.setPaymentFlow(PgCheckoutPaymentFlow.builder().message(message).paymentModeConfig(paymentModeConfig).merchantUrls(merchantUrls).build());
    }

    public CreateSdkOrderRequest(@NotNull String merchantOrderId, long amount, MetaInfo metaInfo, List<InstrumentConstraint> constraints, Long expireAfter, Boolean disablePaymentRetry) {
        this.merchantOrderId = merchantOrderId;
        this.amount = amount;
        this.metaInfo = metaInfo;
        this.expireAfter = expireAfter;
        this.constraints = constraints;
        this.disablePaymentRetry = disablePaymentRetry;
        this.setPaymentFlow(PgPaymentFlow.builder().build());
    }

    public static StandardCheckoutBuilder StandardCheckoutBuilder() {
        return new StandardCheckoutBuilder();
    }

    public static CustomCheckoutBuilder CustomCheckoutBuilder() {
        return new CustomCheckoutBuilder();
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public long getAmount() {
        return this.amount;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public PaymentFlow getPaymentFlow() {
        return this.paymentFlow;
    }

    public Long getExpireAfter() {
        return this.expireAfter;
    }

    public List<InstrumentConstraint> getConstraints() {
        return this.constraints;
    }

    public Boolean getDisablePaymentRetry() {
        return this.disablePaymentRetry;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setPaymentFlow(PaymentFlow paymentFlow) {
        this.paymentFlow = paymentFlow;
    }

    public void setExpireAfter(Long expireAfter) {
        this.expireAfter = expireAfter;
    }

    public void setConstraints(List<InstrumentConstraint> constraints) {
        this.constraints = constraints;
    }

    public void setDisablePaymentRetry(Boolean disablePaymentRetry) {
        this.disablePaymentRetry = disablePaymentRetry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSdkOrderRequest)) {
            return false;
        }
        CreateSdkOrderRequest other = (CreateSdkOrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        Long this$expireAfter = this.getExpireAfter();
        Long other$expireAfter = other.getExpireAfter();
        if (this$expireAfter == null ? other$expireAfter != null : !((Object)this$expireAfter).equals(other$expireAfter)) {
            return false;
        }
        Boolean this$disablePaymentRetry = this.getDisablePaymentRetry();
        Boolean other$disablePaymentRetry = other.getDisablePaymentRetry();
        if (this$disablePaymentRetry == null ? other$disablePaymentRetry != null : !((Object)this$disablePaymentRetry).equals(other$disablePaymentRetry)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        MetaInfo this$metaInfo = this.getMetaInfo();
        MetaInfo other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !((Object)this$metaInfo).equals(other$metaInfo)) {
            return false;
        }
        PaymentFlow this$paymentFlow = this.getPaymentFlow();
        PaymentFlow other$paymentFlow = other.getPaymentFlow();
        if (this$paymentFlow == null ? other$paymentFlow != null : !((Object)this$paymentFlow).equals(other$paymentFlow)) {
            return false;
        }
        List<InstrumentConstraint> this$constraints = this.getConstraints();
        List<InstrumentConstraint> other$constraints = other.getConstraints();
        return !(this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateSdkOrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        Long $expireAfter = this.getExpireAfter();
        result = result * 59 + ($expireAfter == null ? 43 : ((Object)$expireAfter).hashCode());
        Boolean $disablePaymentRetry = this.getDisablePaymentRetry();
        result = result * 59 + ($disablePaymentRetry == null ? 43 : ((Object)$disablePaymentRetry).hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        MetaInfo $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : ((Object)$metaInfo).hashCode());
        PaymentFlow $paymentFlow = this.getPaymentFlow();
        result = result * 59 + ($paymentFlow == null ? 43 : ((Object)$paymentFlow).hashCode());
        List<InstrumentConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        return result;
    }

    public String toString() {
        return "CreateSdkOrderRequest(merchantOrderId=" + this.getMerchantOrderId() + ", amount=" + this.getAmount() + ", metaInfo=" + String.valueOf(this.getMetaInfo()) + ", paymentFlow=" + String.valueOf(this.getPaymentFlow()) + ", expireAfter=" + this.getExpireAfter() + ", constraints=" + String.valueOf(this.getConstraints()) + ", disablePaymentRetry=" + this.getDisablePaymentRetry() + ")";
    }

    public static class StandardCheckoutBuilder {
        private long amount;
        private String merchantOrderId;
        private MetaInfo metaInfo;
        private String message;
        private String redirectUrl;
        private Long expireAfter;
        private Boolean disablePaymentRetry;
        private PaymentModeConfig paymentModeConfig;

        StandardCheckoutBuilder() {
        }

        public StandardCheckoutBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public StandardCheckoutBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public StandardCheckoutBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public StandardCheckoutBuilder message(String message) {
            this.message = message;
            return this;
        }

        public StandardCheckoutBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public StandardCheckoutBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public StandardCheckoutBuilder disablePaymentRetry(Boolean disablePaymentRetry) {
            this.disablePaymentRetry = disablePaymentRetry;
            return this;
        }

        public StandardCheckoutBuilder paymentModeConfig(PaymentModeConfig paymentModeConfig) {
            this.paymentModeConfig = paymentModeConfig;
            return this;
        }

        public CreateSdkOrderRequest build() {
            return new CreateSdkOrderRequest(this.amount, this.merchantOrderId, this.metaInfo, this.message, this.redirectUrl, this.expireAfter, this.disablePaymentRetry, this.paymentModeConfig);
        }

        public String toString() {
            return "CreateSdkOrderRequest.StandardCheckoutBuilder(amount=" + this.amount + ", merchantOrderId=" + this.merchantOrderId + ", metaInfo=" + String.valueOf(this.metaInfo) + ", message=" + this.message + ", redirectUrl=" + this.redirectUrl + ", expireAfter=" + this.expireAfter + ", disablePaymentRetry=" + this.disablePaymentRetry + ", paymentModeConfig=" + String.valueOf(this.paymentModeConfig) + ")";
        }
    }

    public static class CustomCheckoutBuilder {
        private String merchantOrderId;
        private long amount;
        private MetaInfo metaInfo;
        private List<InstrumentConstraint> constraints;
        private Long expireAfter;
        private Boolean disablePaymentRetry;

        CustomCheckoutBuilder() {
        }

        public CustomCheckoutBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public CustomCheckoutBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public CustomCheckoutBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public CustomCheckoutBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public CustomCheckoutBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public CustomCheckoutBuilder disablePaymentRetry(Boolean disablePaymentRetry) {
            this.disablePaymentRetry = disablePaymentRetry;
            return this;
        }

        public CreateSdkOrderRequest build() {
            return new CreateSdkOrderRequest(this.merchantOrderId, this.amount, this.metaInfo, this.constraints, this.expireAfter, this.disablePaymentRetry);
        }

        public String toString() {
            return "CreateSdkOrderRequest.CustomCheckoutBuilder(merchantOrderId=" + this.merchantOrderId + ", amount=" + this.amount + ", metaInfo=" + String.valueOf(this.metaInfo) + ", constraints=" + String.valueOf(this.constraints) + ", expireAfter=" + this.expireAfter + ", disablePaymentRetry=" + this.disablePaymentRetry + ")";
        }
    }
}

