/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.payments.v2.models.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.PaymentFlowType;
import com.phonepe.sdk.pg.common.models.request.PaymentFlow;
import com.phonepe.sdk.pg.payments.v2.models.request.MerchantUrls;
import com.phonepe.sdk.pg.payments.v2.models.request.PaymentModeConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PgCheckoutPaymentFlow
extends PaymentFlow {
    private String message;
    private MerchantUrls merchantUrls;
    private PaymentModeConfig paymentModeConfig;

    public PgCheckoutPaymentFlow(String message, MerchantUrls merchantUrls, PaymentModeConfig paymentModeConfig) {
        super(PaymentFlowType.PG_CHECKOUT);
        this.message = message;
        this.merchantUrls = merchantUrls;
        this.paymentModeConfig = paymentModeConfig;
    }

    public static PgCheckoutPaymentFlowBuilder builder() {
        return new PgCheckoutPaymentFlowBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public MerchantUrls getMerchantUrls() {
        return this.merchantUrls;
    }

    public PaymentModeConfig getPaymentModeConfig() {
        return this.paymentModeConfig;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMerchantUrls(MerchantUrls merchantUrls) {
        this.merchantUrls = merchantUrls;
    }

    public void setPaymentModeConfig(PaymentModeConfig paymentModeConfig) {
        this.paymentModeConfig = paymentModeConfig;
    }

    @Override
    public String toString() {
        return "PgCheckoutPaymentFlow(message=" + this.getMessage() + ", merchantUrls=" + String.valueOf(this.getMerchantUrls()) + ", paymentModeConfig=" + String.valueOf(this.getPaymentModeConfig()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PgCheckoutPaymentFlow)) {
            return false;
        }
        PgCheckoutPaymentFlow other = (PgCheckoutPaymentFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        MerchantUrls this$merchantUrls = this.getMerchantUrls();
        MerchantUrls other$merchantUrls = other.getMerchantUrls();
        if (this$merchantUrls == null ? other$merchantUrls != null : !((Object)this$merchantUrls).equals(other$merchantUrls)) {
            return false;
        }
        PaymentModeConfig this$paymentModeConfig = this.getPaymentModeConfig();
        PaymentModeConfig other$paymentModeConfig = other.getPaymentModeConfig();
        return !(this$paymentModeConfig == null ? other$paymentModeConfig != null : !((Object)this$paymentModeConfig).equals(other$paymentModeConfig));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PgCheckoutPaymentFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        MerchantUrls $merchantUrls = this.getMerchantUrls();
        result = result * 59 + ($merchantUrls == null ? 43 : ((Object)$merchantUrls).hashCode());
        PaymentModeConfig $paymentModeConfig = this.getPaymentModeConfig();
        result = result * 59 + ($paymentModeConfig == null ? 43 : ((Object)$paymentModeConfig).hashCode());
        return result;
    }

    public static class PgCheckoutPaymentFlowBuilder {
        private String message;
        private MerchantUrls merchantUrls;
        private PaymentModeConfig paymentModeConfig;

        PgCheckoutPaymentFlowBuilder() {
        }

        public PgCheckoutPaymentFlowBuilder message(String message) {
            this.message = message;
            return this;
        }

        public PgCheckoutPaymentFlowBuilder merchantUrls(MerchantUrls merchantUrls) {
            this.merchantUrls = merchantUrls;
            return this;
        }

        public PgCheckoutPaymentFlowBuilder paymentModeConfig(PaymentModeConfig paymentModeConfig) {
            this.paymentModeConfig = paymentModeConfig;
            return this;
        }

        public PgCheckoutPaymentFlow build() {
            return new PgCheckoutPaymentFlow(this.message, this.merchantUrls, this.paymentModeConfig);
        }

        public String toString() {
            return "PgCheckoutPaymentFlow.PgCheckoutPaymentFlowBuilder(message=" + this.message + ", merchantUrls=" + String.valueOf(this.merchantUrls) + ", paymentModeConfig=" + String.valueOf(this.paymentModeConfig) + ")";
        }
    }
}

