/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.subscription.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.phonepe.sdk.pg.Env;
import com.phonepe.sdk.pg.common.BaseClient;
import com.phonepe.sdk.pg.common.CommonUtils;
import com.phonepe.sdk.pg.common.constants.Headers;
import com.phonepe.sdk.pg.common.events.models.BaseEvent;
import com.phonepe.sdk.pg.common.events.models.enums.EventState;
import com.phonepe.sdk.pg.common.events.models.enums.EventType;
import com.phonepe.sdk.pg.common.events.models.enums.FlowType;
import com.phonepe.sdk.pg.common.exception.PhonePeException;
import com.phonepe.sdk.pg.common.http.HttpHeaderPair;
import com.phonepe.sdk.pg.common.http.HttpMethodType;
import com.phonepe.sdk.pg.common.models.request.PgPaymentRequest;
import com.phonepe.sdk.pg.common.models.request.RefundRequest;
import com.phonepe.sdk.pg.common.models.response.CallbackResponse;
import com.phonepe.sdk.pg.common.models.response.OrderStatusResponse;
import com.phonepe.sdk.pg.common.models.response.PgPaymentResponse;
import com.phonepe.sdk.pg.common.models.response.RefundResponse;
import com.phonepe.sdk.pg.common.models.response.RefundStatusResponse;
import com.phonepe.sdk.pg.subscription.v2.models.request.SubscriptionRedeemRequestV2;
import com.phonepe.sdk.pg.subscription.v2.models.response.SubscriptionRedeemResponseV2;
import com.phonepe.sdk.pg.subscription.v2.models.response.SubscriptionStatusResponseV2;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionClient
extends BaseClient {
    private List<HttpHeaderPair> headers;

    private SubscriptionClient(String clientId, String clientSecret, Integer clientVersion, Env env, boolean shouldPublishEvents) {
        super(clientId, clientSecret, clientVersion, env, shouldPublishEvents);
        this.eventPublisher.send(BaseEvent.buildInitClientEvent(FlowType.SUBSCRIPTION, EventType.SUBSCRIPTION_CLIENT_INITIALIZED));
        this.prepareHeaders();
    }

    public static SubscriptionClient getInstance(String clientId, String clientSecret, Integer clientVersion, Env env) throws PhonePeException {
        return SubscriptionClient.getInstance(clientId, clientSecret, clientVersion, env, true);
    }

    public static SubscriptionClient getInstance(String clientId, String clientSecret, Integer clientVersion, Env env, boolean shouldPublishEvents) throws PhonePeException {
        boolean shouldPublishInProd = shouldPublishEvents && env == Env.PRODUCTION;
        return new SubscriptionClient(clientId, clientSecret, clientVersion, env, shouldPublishInProd);
    }

    public PgPaymentResponse setup(PgPaymentRequest request) {
        String url = "/subscriptions/v2/setup";
        try {
            PgPaymentResponse response = this.requestViaAuthRefresh(HttpMethodType.POST, request, "/subscriptions/v2/setup", null, new TypeReference<PgPaymentResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildSubscriptionSetupEvent(EventState.SUCCESS, request, "/subscriptions/v2/setup", EventType.SETUP_SUCCESS));
            return response;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildSubscriptionSetupEvent(EventState.FAILED, request, "/subscriptions/v2/setup", EventType.SETUP_FAILED, exception));
            throw exception;
        }
    }

    public PgPaymentResponse notify(PgPaymentRequest request) {
        String url = "/subscriptions/v2/notify";
        try {
            PgPaymentResponse response = this.requestViaAuthRefresh(HttpMethodType.POST, request, "/subscriptions/v2/notify", null, new TypeReference<PgPaymentResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildSubscriptionNotifyEvent(EventState.SUCCESS, request, "/subscriptions/v2/notify", EventType.NOTIFY_SUCCESS));
            return response;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildSubscriptionNotifyEvent(EventState.FAILED, request, "/subscriptions/v2/notify", EventType.NOTIFY_FAILED, exception));
            throw exception;
        }
    }

    public SubscriptionRedeemResponseV2 redeem(String merchantOrderId) {
        String url = "/subscriptions/v2/redeem";
        try {
            SubscriptionRedeemRequestV2 request = new SubscriptionRedeemRequestV2(merchantOrderId);
            SubscriptionRedeemResponseV2 response = this.requestViaAuthRefresh(HttpMethodType.POST, request, "/subscriptions/v2/redeem", null, new TypeReference<SubscriptionRedeemResponseV2>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildSubscriptionRedeemEvent(EventState.SUCCESS, merchantOrderId, "/subscriptions/v2/redeem", EventType.REDEEM_SUCCESS));
            return response;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildSubscriptionRedeemEvent(EventState.FAILED, merchantOrderId, "/subscriptions/v2/redeem", EventType.REDEEM_FAILED, exception));
            throw exception;
        }
    }

    public SubscriptionStatusResponseV2 getSubscriptionStatus(String merchantSubscriptionId) {
        String url = String.format("/subscriptions/v2/%s/status", merchantSubscriptionId);
        try {
            SubscriptionStatusResponseV2 response = this.requestViaAuthRefresh(HttpMethodType.GET, null, url, null, new TypeReference<SubscriptionStatusResponseV2>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildSubscriptionStatusEvent(EventState.SUCCESS, merchantSubscriptionId, url, EventType.SUBSCRIPTION_STATUS_SUCCESS));
            return response;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildSubscriptionStatusEvent(EventState.FAILED, merchantSubscriptionId, url, EventType.SUBSCRIPTION_STATUS_FAILED, exception));
            throw exception;
        }
    }

    public OrderStatusResponse getOrderStatus(String merchantOrderId) {
        String url = String.format("/subscriptions/v2/order/%s/status", merchantOrderId);
        try {
            OrderStatusResponse response = this.requestViaAuthRefresh(HttpMethodType.GET, null, url, null, new TypeReference<OrderStatusResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildOrderStatusEvent(EventState.SUCCESS, merchantOrderId, url, FlowType.SUBSCRIPTION, EventType.ORDER_STATUS_SUCCESS));
            return response;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildOrderStatusEvent(EventState.FAILED, merchantOrderId, url, FlowType.SUBSCRIPTION, EventType.ORDER_STATUS_FAILED, exception));
            throw exception;
        }
    }

    public void cancelSubscription(String merchantSubscriptionId) {
        String url = String.format("/subscriptions/v2/%s/cancel", merchantSubscriptionId);
        try {
            this.requestViaAuthRefresh(HttpMethodType.POST, null, url, null, new TypeReference<Void>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildSubscriptionCancelEvent(EventState.SUCCESS, merchantSubscriptionId, url, EventType.CANCEL_SUCCESS));
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildSubscriptionCancelEvent(EventState.FAILED, merchantSubscriptionId, url, EventType.CANCEL_FAILED, exception));
            throw exception;
        }
    }

    public OrderStatusResponse getTransactionStatus(String transactionId) {
        String url = String.format("/subscriptions/v2/transaction/%s/status", transactionId);
        try {
            OrderStatusResponse response = this.requestViaAuthRefresh(HttpMethodType.GET, null, url, null, new TypeReference<OrderStatusResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildTransactionStatusEvent(EventState.SUCCESS, transactionId, url, FlowType.SUBSCRIPTION, EventType.TRANSACTION_STATUS_SUCCESS));
            return response;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildTransactionStatusEvent(EventState.FAILED, transactionId, url, FlowType.SUBSCRIPTION, EventType.TRANSACTION_STATUS_FAILED, exception));
            throw exception;
        }
    }

    public RefundResponse refund(RefundRequest refundRequest) {
        String url = "/payments/v2/refund";
        try {
            RefundResponse refundResponse = this.requestViaAuthRefresh(HttpMethodType.POST, refundRequest, "/payments/v2/refund", null, new TypeReference<RefundResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildRefundEvent(EventState.SUCCESS, refundRequest, "/payments/v2/refund", FlowType.SUBSCRIPTION, EventType.REFUND_SUCCESS));
            return refundResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildRefundEvent(EventState.FAILED, refundRequest, "/payments/v2/refund", FlowType.SUBSCRIPTION, EventType.REFUND_FAILED, exception));
            throw exception;
        }
    }

    public RefundStatusResponse getRefundStatus(String refundId) {
        String url = String.format("/payments/v2/refund/%s/status", refundId);
        try {
            RefundStatusResponse refundStatusResponse = this.requestViaAuthRefresh(HttpMethodType.GET, null, url, null, new TypeReference<RefundStatusResponse>(){}, this.headers);
            this.eventPublisher.send(BaseEvent.buildRefundStatusEvent(EventState.SUCCESS, refundId, url, FlowType.SUBSCRIPTION, EventType.REFUND_STATUS_SUCCESS));
            return refundStatusResponse;
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildRefundStatusEvent(EventState.FAILED, refundId, url, FlowType.SUBSCRIPTION, EventType.REFUND_STATUS_FAILED, exception));
            throw exception;
        }
    }

    public CallbackResponse validateCallback(String username, String password, String authorization, String responseBody) {
        if (!CommonUtils.isCallbackValid(username, password, authorization)) {
            throw new PhonePeException(417, "Invalid Callback");
        }
        try {
            return (CallbackResponse)this.getObjectMapper().readValue(responseBody, CallbackResponse.class);
        }
        catch (Exception exception) {
            this.eventPublisher.send(BaseEvent.buildCallbackSerializationFailedEvent(EventState.FAILED, FlowType.SUBSCRIPTION, EventType.CALLBACK_SERIALIZATION_FAILED, exception));
            throw exception;
        }
    }

    private void prepareHeaders() {
        this.headers = new ArrayList<HttpHeaderPair>();
        this.headers.add(HttpHeaderPair.builder().key("Content-Type").value("application/json").build());
        this.headers.add(HttpHeaderPair.builder().key("x-source").value("API").build());
        this.headers.add(HttpHeaderPair.builder().key("x-source-version").value(Headers.SUBSCRIPTION_API_VERSION).build());
        this.headers.add(HttpHeaderPair.builder().key("x-source-platform").value("BACKEND_JAVA_SDK").build());
        this.headers.add(HttpHeaderPair.builder().key("x-source-platform-version").value(Headers.SDK_VERSION).build());
    }
}

