/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.subscription.v2.models.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.PaymentFlowType;
import com.phonepe.sdk.pg.common.models.request.PaymentFlow;
import com.phonepe.sdk.pg.subscription.v2.models.request.RedemptionRetryStrategy;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SubscriptionRedemptionPaymentFlow
extends PaymentFlow {
    private String merchantSubscriptionId;
    private RedemptionRetryStrategy redemptionRetryStrategy;
    private boolean autoDebit;

    public SubscriptionRedemptionPaymentFlow(String merchantSubscriptionId, RedemptionRetryStrategy redemptionRetryStrategy, boolean autoDebit) {
        super(PaymentFlowType.SUBSCRIPTION_REDEMPTION);
        this.merchantSubscriptionId = merchantSubscriptionId;
        this.redemptionRetryStrategy = redemptionRetryStrategy;
        this.autoDebit = autoDebit;
    }

    public static SubscriptionRedemptionPaymentFlowBuilder builder() {
        return new SubscriptionRedemptionPaymentFlowBuilder();
    }

    public String getMerchantSubscriptionId() {
        return this.merchantSubscriptionId;
    }

    public RedemptionRetryStrategy getRedemptionRetryStrategy() {
        return this.redemptionRetryStrategy;
    }

    public boolean isAutoDebit() {
        return this.autoDebit;
    }

    public void setMerchantSubscriptionId(String merchantSubscriptionId) {
        this.merchantSubscriptionId = merchantSubscriptionId;
    }

    public void setRedemptionRetryStrategy(RedemptionRetryStrategy redemptionRetryStrategy) {
        this.redemptionRetryStrategy = redemptionRetryStrategy;
    }

    public void setAutoDebit(boolean autoDebit) {
        this.autoDebit = autoDebit;
    }

    @Override
    public String toString() {
        return "SubscriptionRedemptionPaymentFlow(merchantSubscriptionId=" + this.getMerchantSubscriptionId() + ", redemptionRetryStrategy=" + String.valueOf((Object)this.getRedemptionRetryStrategy()) + ", autoDebit=" + this.isAutoDebit() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionRedemptionPaymentFlow)) {
            return false;
        }
        SubscriptionRedemptionPaymentFlow other = (SubscriptionRedemptionPaymentFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAutoDebit() != other.isAutoDebit()) {
            return false;
        }
        String this$merchantSubscriptionId = this.getMerchantSubscriptionId();
        String other$merchantSubscriptionId = other.getMerchantSubscriptionId();
        if (this$merchantSubscriptionId == null ? other$merchantSubscriptionId != null : !this$merchantSubscriptionId.equals(other$merchantSubscriptionId)) {
            return false;
        }
        RedemptionRetryStrategy this$redemptionRetryStrategy = this.getRedemptionRetryStrategy();
        RedemptionRetryStrategy other$redemptionRetryStrategy = other.getRedemptionRetryStrategy();
        return !(this$redemptionRetryStrategy == null ? other$redemptionRetryStrategy != null : !((Object)((Object)this$redemptionRetryStrategy)).equals((Object)other$redemptionRetryStrategy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionRedemptionPaymentFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAutoDebit() ? 79 : 97);
        String $merchantSubscriptionId = this.getMerchantSubscriptionId();
        result = result * 59 + ($merchantSubscriptionId == null ? 43 : $merchantSubscriptionId.hashCode());
        RedemptionRetryStrategy $redemptionRetryStrategy = this.getRedemptionRetryStrategy();
        result = result * 59 + ($redemptionRetryStrategy == null ? 43 : ((Object)((Object)$redemptionRetryStrategy)).hashCode());
        return result;
    }

    public static class SubscriptionRedemptionPaymentFlowBuilder {
        private String merchantSubscriptionId;
        private RedemptionRetryStrategy redemptionRetryStrategy;
        private boolean autoDebit;

        SubscriptionRedemptionPaymentFlowBuilder() {
        }

        public SubscriptionRedemptionPaymentFlowBuilder merchantSubscriptionId(String merchantSubscriptionId) {
            this.merchantSubscriptionId = merchantSubscriptionId;
            return this;
        }

        public SubscriptionRedemptionPaymentFlowBuilder redemptionRetryStrategy(RedemptionRetryStrategy redemptionRetryStrategy) {
            this.redemptionRetryStrategy = redemptionRetryStrategy;
            return this;
        }

        public SubscriptionRedemptionPaymentFlowBuilder autoDebit(boolean autoDebit) {
            this.autoDebit = autoDebit;
            return this;
        }

        public SubscriptionRedemptionPaymentFlow build() {
            return new SubscriptionRedemptionPaymentFlow(this.merchantSubscriptionId, this.redemptionRetryStrategy, this.autoDebit);
        }

        public String toString() {
            return "SubscriptionRedemptionPaymentFlow.SubscriptionRedemptionPaymentFlowBuilder(merchantSubscriptionId=" + this.merchantSubscriptionId + ", redemptionRetryStrategy=" + String.valueOf((Object)this.redemptionRetryStrategy) + ", autoDebit=" + this.autoDebit + ")";
        }
    }
}

