/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.pg.Env;
import com.phonepe.sdk.pg.common.configs.CredentialConfig;
import com.phonepe.sdk.pg.common.events.publisher.EventPublisher;
import com.phonepe.sdk.pg.common.events.publisher.EventPublisherFactory;
import com.phonepe.sdk.pg.common.exception.UnauthorizedAccess;
import com.phonepe.sdk.pg.common.http.HttpCommand;
import com.phonepe.sdk.pg.common.http.HttpHeaderPair;
import com.phonepe.sdk.pg.common.http.HttpMethodType;
import com.phonepe.sdk.pg.common.tokenhandler.TokenService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;

public abstract class BaseClient {
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient = new OkHttpClient();
    private final Env env;
    private TokenService tokenService;
    private CredentialConfig credentialConfig;
    protected EventPublisherFactory eventPublisherFactory;
    protected EventPublisher eventPublisher;
    private boolean shouldPublishEvents;

    protected BaseClient(String clientId, String clientSecret, Integer clientVersion, Env env, boolean shouldPublishEvents) {
        this.objectMapper = new ObjectMapper();
        this.env = env;
        this.credentialConfig = CredentialConfig.builder().clientId(clientId).clientSecret(clientSecret).clientVersion(clientVersion).build();
        this.shouldPublishEvents = shouldPublishEvents;
        this.eventPublisherFactory = new EventPublisherFactory(this.getObjectMapper(), this.getOkHttpClient(), env.getEventsHostUrl());
        this.eventPublisher = this.eventPublisherFactory.getEventPublisher(shouldPublishEvents);
        this.tokenService = new TokenService(this.okHttpClient, this.objectMapper, this.credentialConfig, this.env, this.eventPublisher);
        this.eventPublisher.startPublishingEvents(this.tokenService::getAuthToken);
    }

    protected <T, R> T requestViaAuthRefresh(HttpMethodType methodName, R requestData, String url, Map<String, String> queryParams, TypeReference<T> responseTypeReference, List<HttpHeaderPair> headers) {
        ArrayList<HttpHeaderPair> httpHeaders = new ArrayList<HttpHeaderPair>(headers);
        HttpCommand httpCommand = HttpCommand.builder().client(this.okHttpClient).objectMapper(this.objectMapper).responseTypeReference(responseTypeReference).methodName(methodName).headers(this.addAuthHeader(httpHeaders)).requestData(requestData).hostURL(this.env.getPgHostUrl()).encodingType("application/json").queryParams(queryParams).url(url).build();
        try {
            return httpCommand.execute();
        }
        catch (UnauthorizedAccess unauthorizedAccess) {
            this.tokenService.forceRefreshToken();
            throw unauthorizedAccess;
        }
    }

    protected List<HttpHeaderPair> addAuthHeader(List<HttpHeaderPair> headers) {
        headers.add(HttpHeaderPair.builder().key("Authorization").value(this.tokenService.getAuthToken()).build());
        return headers;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public Env getEnv() {
        return this.env;
    }

    public TokenService getTokenService() {
        return this.tokenService;
    }

    public CredentialConfig getCredentialConfig() {
        return this.credentialConfig;
    }

    public EventPublisherFactory getEventPublisherFactory() {
        return this.eventPublisherFactory;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public boolean isShouldPublishEvents() {
        return this.shouldPublishEvents;
    }
}

