/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.constants;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Headers {
    private static final Logger log = LoggerFactory.getLogger(Headers.class);
    private static final Properties properties = new Properties();
    private static final String PROPERTIES_FILE_NAME = "/sdk.properties";
    public static final String API_VERSION = "V2";
    public static final String SUBSCRIPTION_API_VERSION;
    public static final String INTEGRATION = "API";
    public static final String SDK_VERSION;
    public static final String SDK_TYPE = "BACKEND_JAVA_SDK";
    public static final String SOURCE = "x-source";
    public static final String SOURCE_VERSION = "x-source-version";
    public static final String SOURCE_PLATFORM = "x-source-platform";
    public static final String SOURCE_PLATFORM_VERSION = "x-source-platform-version";
    public static final String OAUTH_AUTHORIZATION = "Authorization";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";

    private Headers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try (InputStream input = Headers.class.getResourceAsStream(PROPERTIES_FILE_NAME);){
            if (input == null) {
                log.error("Could not find {}", (Object)PROPERTIES_FILE_NAME);
            } else {
                properties.load(input);
            }
        }
        catch (Exception e) {
            log.error("Failed to load SDK properties: {}", (Object)e.getMessage());
        }
        SUBSCRIPTION_API_VERSION = properties.getProperty("sdk.version");
        SDK_VERSION = properties.getProperty("sdk.version");
    }
}

