/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.events.models;

import com.phonepe.sdk.pg.common.events.models.EventData;
import com.phonepe.sdk.pg.common.events.models.SubscriptionEventData;
import com.phonepe.sdk.pg.common.events.models.enums.EventState;
import com.phonepe.sdk.pg.common.events.models.enums.EventType;
import com.phonepe.sdk.pg.common.events.models.enums.FlowType;
import com.phonepe.sdk.pg.common.exception.PhonePeException;
import com.phonepe.sdk.pg.common.models.PgV2InstrumentType;
import com.phonepe.sdk.pg.common.models.request.PgPaymentRequest;
import com.phonepe.sdk.pg.common.models.request.RefundRequest;
import com.phonepe.sdk.pg.common.models.request.instruments.IntentPaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.PaymentV2Instrument;
import com.phonepe.sdk.pg.payments.v2.models.request.CreateSdkOrderRequest;
import com.phonepe.sdk.pg.payments.v2.models.request.PgPaymentFlow;
import com.phonepe.sdk.pg.payments.v2.models.request.StandardCheckoutPayRequest;
import com.phonepe.sdk.pg.subscription.v2.models.request.SubscriptionRedemptionPaymentFlow;
import com.phonepe.sdk.pg.subscription.v2.models.request.SubscriptionSetupPaymentFlow;
import java.time.Instant;
import java.util.Optional;

public class BaseEvent {
    private String merchantOrderId;
    private EventType eventName;
    private long eventTime;
    private EventData data;

    public static BaseEvent buildInitClientEvent(FlowType flowType, EventType eventName) {
        BaseEvent baseEvent = BaseEvent.buildInitClientEvent(eventName);
        baseEvent.data.setFlowType(flowType);
        return baseEvent;
    }

    public static BaseEvent buildInitClientEvent(EventType eventName) {
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).data(EventData.builder().eventState(EventState.INITIATED).build()).build();
    }

    public static BaseEvent buildStandardCheckoutPayEvent(EventState eventState, StandardCheckoutPayRequest standardCheckoutPayRequest, String apiPath, EventType eventName) {
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).merchantOrderId(standardCheckoutPayRequest.getMerchantOrderId()).data(EventData.builder().eventState(eventState).amount(standardCheckoutPayRequest.getAmount()).apiPath(apiPath).expireAfter(standardCheckoutPayRequest.getExpireAfter()).flowType(FlowType.PG_CHECKOUT).build()).build();
    }

    public static BaseEvent buildStandardCheckoutPayEvent(EventState eventState, StandardCheckoutPayRequest standardCheckoutPayRequest, String apiPath, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.buildStandardCheckoutPayEvent(eventState, standardCheckoutPayRequest, apiPath, eventName);
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildCustomCheckoutPayEvent(EventState eventState, PgPaymentRequest pgPaymentRequest, String apiPath, EventType eventName) {
        PgPaymentFlow pgPaymentFlow = (PgPaymentFlow)pgPaymentRequest.getPaymentFlow();
        String targetApp = Optional.ofNullable(pgPaymentFlow).map(PgPaymentFlow::getPaymentMode).filter(paymentMode -> paymentMode.getType().equals((Object)PgV2InstrumentType.UPI_INTENT)).map(IntentPaymentV2Instrument.class::cast).map(IntentPaymentV2Instrument::getTargetApp).orElse(null);
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).merchantOrderId(pgPaymentRequest.getMerchantOrderId()).data(EventData.builder().eventState(eventState).amount(pgPaymentRequest.getAmount()).apiPath(apiPath).deviceContext(pgPaymentRequest.getDeviceContext()).expireAfter(pgPaymentRequest.getExpireAfter()).targetApp(targetApp).paymentInstrument(Optional.ofNullable(pgPaymentFlow).map(PgPaymentFlow::getPaymentMode).map(PaymentV2Instrument::getType).orElse(null)).flowType(FlowType.PG).build()).build();
    }

    public static BaseEvent buildCustomCheckoutPayEvent(EventState eventState, PgPaymentRequest pgPaymentRequest, String url, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.buildCustomCheckoutPayEvent(eventState, pgPaymentRequest, url, eventName);
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildOrderStatusEvent(EventState eventState, String merchantOrderId, String apiPath, FlowType flowType, EventType eventName) {
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).merchantOrderId(merchantOrderId).data(EventData.builder().eventState(eventState).flowType(flowType).apiPath(apiPath).build()).build();
    }

    public static BaseEvent buildOrderStatusEvent(EventState eventState, String merchantOrderId, String apiPath, FlowType flowType, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.buildOrderStatusEvent(eventState, merchantOrderId, apiPath, flowType, eventName);
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildRefundEvent(EventState eventState, RefundRequest refundRequest, String apiPath, FlowType flowType, EventType eventName) {
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).merchantOrderId(refundRequest.getOriginalMerchantOrderId()).data(EventData.builder().merchantRefundId(refundRequest.getMerchantRefundId()).eventState(eventState).apiPath(apiPath).amount(refundRequest.getAmount()).originalMerchantOrderId(refundRequest.getOriginalMerchantOrderId()).flowType(flowType).build()).build();
    }

    public static BaseEvent buildRefundEvent(EventState eventState, RefundRequest refundRequest, String apiPath, FlowType flowType, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.buildRefundEvent(eventState, refundRequest, apiPath, flowType, eventName);
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildRefundStatusEvent(EventState eventState, String refundId, String apiPath, FlowType flowType, EventType eventName) {
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).data(EventData.builder().merchantRefundId(refundId).eventState(eventState).apiPath(apiPath).flowType(flowType).build()).build();
    }

    public static BaseEvent buildRefundStatusEvent(EventState eventState, String refundId, String apiPath, FlowType flowType, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.buildRefundStatusEvent(eventState, refundId, apiPath, flowType, eventName);
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildCreateSdkOrderEvent(EventState eventState, CreateSdkOrderRequest createSdkOrderRequest, String apiPath, FlowType flowType, EventType eventName) {
        return BaseEvent.builder().merchantOrderId(createSdkOrderRequest.getMerchantOrderId()).eventName(eventName).eventTime(Instant.now().getEpochSecond()).data(EventData.builder().amount(createSdkOrderRequest.getAmount()).eventState(eventState).apiPath(apiPath).expireAfter(createSdkOrderRequest.getExpireAfter()).flowType(flowType).build()).build();
    }

    public static BaseEvent buildCreateSdkOrderEvent(EventState eventState, CreateSdkOrderRequest createSdkOrderRequest, String apiPath, FlowType flowType, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.buildCreateSdkOrderEvent(eventState, createSdkOrderRequest, apiPath, flowType, eventName);
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildTransactionStatusEvent(EventState eventState, String transactionId, String apiPath, FlowType flowType, EventType eventName) {
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).data(EventData.builder().eventState(eventState).transactionId(transactionId).apiPath(apiPath).flowType(flowType).build()).build();
    }

    public static BaseEvent buildTransactionStatusEvent(EventState eventState, String transactionId, String apiPath, FlowType flowType, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.buildTransactionStatusEvent(eventState, transactionId, apiPath, flowType, eventName);
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildSubscriptionSetupEvent(EventState eventState, PgPaymentRequest setupRequest, String apiPath, EventType eventName) {
        SubscriptionSetupPaymentFlow setupPaymentFlow = (SubscriptionSetupPaymentFlow)setupRequest.getPaymentFlow();
        String targetApp = Optional.ofNullable(setupPaymentFlow).map(SubscriptionSetupPaymentFlow::getPaymentMode).filter(paymentMode -> paymentMode.getType().equals((Object)PgV2InstrumentType.UPI_INTENT)).map(IntentPaymentV2Instrument.class::cast).map(IntentPaymentV2Instrument::getTargetApp).orElse(null);
        return BaseEvent.builder().merchantOrderId(setupRequest.getMerchantOrderId()).eventTime(Instant.now().getEpochSecond()).eventName(eventName).data(EventData.builder().eventState(eventState).apiPath(apiPath).flowType(FlowType.SUBSCRIPTION).paymentInstrument(Optional.ofNullable(setupPaymentFlow).map(SubscriptionSetupPaymentFlow::getPaymentMode).map(PaymentV2Instrument::getType).orElse(null)).targetApp(targetApp).deviceContext(setupRequest.getDeviceContext()).amount(setupRequest.getAmount()).subscriptionEventData(SubscriptionEventData.builder().orderExpireAt(setupRequest.getExpireAt()).subscriptionExpireAt(Optional.ofNullable(setupPaymentFlow).map(SubscriptionSetupPaymentFlow::getExpireAt).orElse(null)).merchantSubscriptionId(Optional.ofNullable(setupPaymentFlow).map(SubscriptionSetupPaymentFlow::getMerchantSubscriptionId).orElse(null)).build()).build()).build();
    }

    public static BaseEvent buildSubscriptionSetupEvent(EventState eventState, PgPaymentRequest setupRequest, String apiPath, EventType eventName, Exception exception) {
        BaseEvent event = BaseEvent.buildSubscriptionSetupEvent(eventState, setupRequest, apiPath, eventName);
        return BaseEvent.populateExceptionFields(event, exception);
    }

    public static BaseEvent buildSubscriptionNotifyEvent(EventState eventState, PgPaymentRequest notifyRequest, String apiPath, EventType eventName) {
        SubscriptionRedemptionPaymentFlow paymentFlow = (SubscriptionRedemptionPaymentFlow)notifyRequest.getPaymentFlow();
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).merchantOrderId(notifyRequest.getMerchantOrderId()).data(EventData.builder().eventState(eventState).apiPath(apiPath).amount(notifyRequest.getAmount()).flowType(FlowType.SUBSCRIPTION).subscriptionEventData(SubscriptionEventData.builder().orderExpireAt(notifyRequest.getExpireAt()).merchantSubscriptionId(paymentFlow.getMerchantSubscriptionId()).build()).build()).build();
    }

    public static BaseEvent buildSubscriptionNotifyEvent(EventState eventState, PgPaymentRequest notifyRequest, String apiPath, EventType eventName, Exception exception) {
        BaseEvent event = BaseEvent.buildSubscriptionNotifyEvent(eventState, notifyRequest, apiPath, eventName);
        return BaseEvent.populateExceptionFields(event, exception);
    }

    public static BaseEvent buildSubscriptionRedeemEvent(EventState eventState, String merchantOrderId, String apiPath, EventType eventName) {
        return BaseEvent.builder().eventTime(Instant.now().getEpochSecond()).eventName(eventName).merchantOrderId(merchantOrderId).data(EventData.builder().flowType(FlowType.SUBSCRIPTION).eventState(eventState).apiPath(apiPath).build()).build();
    }

    public static BaseEvent buildSubscriptionRedeemEvent(EventState eventState, String merchantOrderId, String apiPath, EventType eventName, Exception exception) {
        BaseEvent event = BaseEvent.buildSubscriptionRedeemEvent(eventState, merchantOrderId, apiPath, eventName);
        return BaseEvent.populateExceptionFields(event, exception);
    }

    public static BaseEvent buildSubscriptionStatusEvent(EventState eventState, String merchantSubscriptionId, String apiPath, EventType eventName) {
        return BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).data(EventData.builder().eventState(eventState).apiPath(apiPath).flowType(FlowType.SUBSCRIPTION).subscriptionEventData(SubscriptionEventData.builder().merchantSubscriptionId(merchantSubscriptionId).build()).build()).build();
    }

    public static BaseEvent buildSubscriptionStatusEvent(EventState eventState, String merchantSubscriptionId, String apiPath, EventType eventName, Exception exception) {
        BaseEvent event = BaseEvent.buildSubscriptionStatusEvent(eventState, merchantSubscriptionId, apiPath, eventName);
        return BaseEvent.populateExceptionFields(event, exception);
    }

    public static BaseEvent buildSubscriptionCancelEvent(EventState eventState, String merchantSubscriptionId, String apiPath, EventType eventName) {
        return BaseEvent.builder().eventTime(Instant.now().getEpochSecond()).eventName(eventName).data(EventData.builder().eventState(eventState).apiPath(apiPath).flowType(FlowType.SUBSCRIPTION).subscriptionEventData(SubscriptionEventData.builder().merchantSubscriptionId(merchantSubscriptionId).build()).build()).build();
    }

    public static BaseEvent buildSubscriptionCancelEvent(EventState eventState, String merchantSubscriptionId, String apiPath, EventType eventName, Exception exception) {
        BaseEvent event = BaseEvent.buildSubscriptionCancelEvent(eventState, merchantSubscriptionId, apiPath, eventName);
        return BaseEvent.populateExceptionFields(event, exception);
    }

    public static BaseEvent buildOAuthEvent(long fetchAttemptTime, String apiPath, EventType eventName, Exception exception, long cachedTokenIssuedAt, long cachedTokenExpiresAt) {
        BaseEvent baseEvent = BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).data(EventData.builder().tokenFetchAttemptTimestamp(fetchAttemptTime).apiPath(apiPath).eventState(EventState.FAILED).cachedTokenExpiresAt(cachedTokenExpiresAt).cachedTokenIssuedAt(cachedTokenIssuedAt).build()).build();
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    public static BaseEvent buildCallbackSerializationFailedEvent(EventState eventState, FlowType flowType, EventType eventName, Exception exception) {
        BaseEvent baseEvent = BaseEvent.builder().eventName(eventName).eventTime(Instant.now().getEpochSecond()).data(EventData.builder().eventState(eventState).flowType(flowType).build()).build();
        return BaseEvent.populateExceptionFields(baseEvent, exception);
    }

    private static BaseEvent populateExceptionFields(BaseEvent baseEvent, Exception exception) {
        baseEvent.data.setExceptionMessage(exception.getMessage());
        baseEvent.data.setExceptionClass(exception.getClass().getSimpleName());
        if (exception instanceof PhonePeException) {
            PhonePeException phonePeException = (PhonePeException)exception;
            baseEvent.data.setExceptionHttpStatusCode(phonePeException.getHttpStatusCode());
            baseEvent.data.setExceptionCode(phonePeException.getCode());
            baseEvent.data.setExceptionData(phonePeException.getData());
        }
        return baseEvent;
    }

    public static BaseEventBuilder builder() {
        return new BaseEventBuilder();
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public EventType getEventName() {
        return this.eventName;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public EventData getData() {
        return this.data;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setEventName(EventType eventName) {
        this.eventName = eventName;
    }

    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    public void setData(EventData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEvent)) {
            return false;
        }
        BaseEvent other = (BaseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEventTime() != other.getEventTime()) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        EventType this$eventName = this.getEventName();
        EventType other$eventName = other.getEventName();
        if (this$eventName == null ? other$eventName != null : !((Object)((Object)this$eventName)).equals((Object)other$eventName)) {
            return false;
        }
        EventData this$data = this.getData();
        EventData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventTime = this.getEventTime();
        result = result * 59 + (int)($eventTime >>> 32 ^ $eventTime);
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        EventType $eventName = this.getEventName();
        result = result * 59 + ($eventName == null ? 43 : ((Object)((Object)$eventName)).hashCode());
        EventData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "BaseEvent(merchantOrderId=" + this.getMerchantOrderId() + ", eventName=" + String.valueOf((Object)this.getEventName()) + ", eventTime=" + this.getEventTime() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public BaseEvent() {
    }

    public BaseEvent(String merchantOrderId, EventType eventName, long eventTime, EventData data) {
        this.merchantOrderId = merchantOrderId;
        this.eventName = eventName;
        this.eventTime = eventTime;
        this.data = data;
    }

    public static class BaseEventBuilder {
        private String merchantOrderId;
        private EventType eventName;
        private long eventTime;
        private EventData data;

        BaseEventBuilder() {
        }

        public BaseEventBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public BaseEventBuilder eventName(EventType eventName) {
            this.eventName = eventName;
            return this;
        }

        public BaseEventBuilder eventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public BaseEventBuilder data(EventData data) {
            this.data = data;
            return this;
        }

        public BaseEvent build() {
            return new BaseEvent(this.merchantOrderId, this.eventName, this.eventTime, this.data);
        }

        public String toString() {
            return "BaseEvent.BaseEventBuilder(merchantOrderId=" + this.merchantOrderId + ", eventName=" + String.valueOf((Object)this.eventName) + ", eventTime=" + this.eventTime + ", data=" + String.valueOf(this.data) + ")";
        }
    }
}

